/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor.routing;

import java.awt.geom.Path2D;
import java.util.ArrayList;

public class SysdynLocalRouter {
    static final double OFFSET = 1.0;
    double aMinX;
    double aMinY;
    double aMaxX;
    double aMaxY;
    double bMinX;
    double bMinY;
    double bMaxX;
    double bMaxY;
    double sx;
    double sy;
    double tx;
    double ty;
    int sourceDirection;
    int targetDirection;
    ArrayList<Double> points;
    Path2D path;
    double xx;
    double xy;
    double yx;
    double yy;

    void routeEast() {
        if (this.bMinX >= this.aMaxX || this.tx >= 0.0 && !(this.bMaxY < this.aMinY) && !(this.aMaxY < this.bMinY)) {
            if (this.ty != 0.0) {
                double mx = 0.5 * (this.aMaxX + this.bMinX);
                this.point(mx, 0.0);
                this.point(mx, this.ty);
            }
        } else {
            double my;
            double x0 = this.bMinX;
            double x1 = this.aMaxX;
            if (this.bMaxY < this.aMinY) {
                my = 0.5 * (this.aMinY + this.bMaxY);
            } else if (this.aMaxY < this.bMinY) {
                my = 0.5 * (this.aMaxY + this.bMinY);
            } else {
                double lowerLength;
                double upperLength;
                double upperX0 = this.bMinX;
                double upperX1 = this.aMaxX;
                double lowerX0 = this.bMinX;
                double lowerX1 = this.aMaxX;
                double upperY = Math.min(this.aMinY, this.bMinY);
                double lowerY = Math.max(this.aMaxY, this.bMaxY);
                if (this.aMinX < this.bMinX) {
                    if (this.ty < 0.5 * (this.aMinY + this.aMaxY)) {
                        lowerX0 = this.aMinX;
                    } else {
                        upperX0 = this.aMinX;
                    }
                }
                if (this.bMaxX > this.aMaxX) {
                    if (this.ty < 0.5 * (this.aMinY + this.aMaxY)) {
                        upperX1 = this.bMaxX;
                    } else {
                        lowerX1 = this.bMaxX;
                    }
                }
                if ((upperLength = upperX1 - upperY + (upperX1 - upperX0) + (this.ty - upperY) + (this.tx - upperX0)) < (lowerLength = lowerX1 + lowerY + (lowerX1 - lowerX0) + (lowerY - this.ty) + (this.tx - lowerX0))) {
                    x0 = upperX0;
                    x1 = upperX1;
                    my = upperY;
                } else {
                    x0 = lowerX0;
                    x1 = lowerX1;
                    my = lowerY;
                }
            }
            this.point(x1, 0.0);
            this.point(x1, my);
            this.point(x0, my);
            this.point(x0, this.ty);
        }
    }

    void routeWest() {
        if (this.tx >= 0.0) {
            double fx = Math.max(this.aMaxX, this.bMaxX);
            double mx = 0.5 * (this.aMaxX + this.bMinX);
            if (this.bMinY >= 0.0 || this.bMaxY <= 0.0 || mx < 0.0) {
                this.point(fx, 0.0);
            } else {
                double my = Math.abs(this.bMinY) + Math.abs(this.ty - this.bMinY) < Math.abs(this.bMaxY) + Math.abs(this.ty - this.bMaxY) ? this.bMinY : this.bMaxY;
                this.point(mx, 0.0);
                this.point(mx, my);
                this.point(fx, my);
            }
            this.point(fx, this.ty);
        } else {
            double fx = Math.max(this.aMaxX, this.bMaxX);
            double mx = 0.5 * (this.aMinX + this.bMaxX);
            this.point(fx, 0.0);
            if (this.ty <= this.aMinY || this.ty >= this.aMaxY || this.tx >= mx && this.ty >= this.aMinY && this.ty <= this.aMaxY) {
                this.point(fx, this.ty);
            } else {
                double my = Math.abs(this.aMinY) + Math.abs(this.ty - this.aMinY) < Math.abs(this.aMaxY) + Math.abs(this.ty - this.aMaxY) ? this.aMinY : this.aMaxY;
                this.point(fx, my);
                this.point(mx, my);
                this.point(mx, this.ty);
            }
        }
    }

    void routeSouth() {
        if (this.tx > 0.0 && (this.bMinY >= 0.0 || this.ty > 0.0 && this.bMinX <= this.aMaxX)) {
            this.point(this.tx, 0.0);
        } else if (this.bMinX > this.aMaxX) {
            double mx = 0.5 * (this.aMaxX + this.bMinX);
            this.point(mx, 0.0);
            this.point(mx, this.bMinY);
            this.point(this.tx, this.bMinY);
        } else {
            double fx = this.aMaxX;
            double my = 0.5 * (this.aMaxY + this.bMinY);
            if (my < this.aMaxY && (this.tx < this.aMinX || this.ty < this.aMinY)) {
                my = Math.min(this.aMinY, this.bMinY);
                if (this.bMaxX > this.aMaxX) {
                    fx = this.bMaxX;
                }
            }
            this.point(fx, 0.0);
            this.point(fx, my);
            this.point(this.tx, my);
        }
    }

    void point(double x, double y) {
        this.lineTo(x * this.xx + y * this.yx + this.sx, x * this.xy + y * this.yy + this.sy);
    }

    void lineTo(double x, double y) {
        double cx = this.path.getCurrentPoint().getX();
        double cy = this.path.getCurrentPoint().getY();
        if (Math.abs(cx - x) < 1.0E-5) {
            if (this.points.size() % 2 == 0) {
                this.points.add(this.points.get(this.points.size() - 2));
            }
            this.points.add(y);
        } else if (Math.abs(cy - y) < 1.0E-5) {
            if (this.points.size() % 2 != 0) {
                this.points.add(cy);
            }
            this.points.add(x);
        }
        this.path.lineTo(x, y);
    }

    void rotate() {
        double temp = this.tx;
        this.tx = this.ty;
        this.ty = -temp;
        temp = this.aMinX;
        this.aMinX = this.aMinY;
        this.aMinY = -this.aMaxX;
        this.aMaxX = this.aMaxY;
        this.aMaxY = -temp;
        temp = this.bMinX;
        this.bMinX = this.bMinY;
        this.bMinY = -this.bMaxX;
        this.bMaxX = this.bMaxY;
        this.bMaxY = -temp;
        temp = this.xx;
        this.xx = -this.xy;
        this.xy = temp;
        temp = this.yx;
        this.yx = -this.yy;
        this.yy = temp;
        --this.targetDirection;
        if (this.targetDirection < 0) {
            this.targetDirection += 4;
        }
        --this.sourceDirection;
    }

    void flip() {
        this.ty = -this.ty;
        double temp = this.aMinY;
        this.aMinY = -this.aMaxY;
        this.aMaxY = -temp;
        temp = this.bMinY;
        this.bMinY = -this.bMaxY;
        this.bMaxY = -temp;
        this.yx = -this.yx;
        this.yy = -this.yy;
        this.targetDirection = (this.targetDirection + 2) % 4;
    }

    void canonicalize() {
        this.aMinX -= this.sx;
        this.aMinY -= this.sy;
        this.aMaxX -= this.sx;
        this.aMaxY -= this.sy;
        this.bMinX -= this.sx;
        this.bMinY -= this.sy;
        this.bMaxX -= this.sx;
        this.bMaxY -= this.sy;
        this.tx -= this.sx;
        this.ty -= this.sy;
        this.yy = 1.0;
        this.xx = 1.0;
        this.yx = 0.0;
        this.xy = 0.0;
        while (this.sourceDirection > 0) {
            this.rotate();
        }
        if (this.targetDirection == 1) {
            this.flip();
        }
    }

    public void route() {
        this.sx = this.aMinX + (this.aMaxX - this.aMinX) / 2.0;
        this.sy = this.aMinY + (this.aMaxY - this.aMinY) / 2.0;
        this.tx = this.bMinX + (this.bMaxX - this.bMinX) / 2.0;
        this.ty = this.bMinY + (this.bMaxY - this.bMinY) / 2.0;
        switch (this.sourceDirection) {
            case 2: {
                this.sx = this.aMinX;
                break;
            }
            case 0: {
                this.sx = this.aMaxX;
                break;
            }
            case 3: {
                this.sy = this.aMinY;
                break;
            }
            case 1: {
                this.sy = this.aMaxY;
            }
        }
        switch (this.targetDirection) {
            case 0: {
                this.tx = this.bMaxX;
                break;
            }
            case 2: {
                this.tx = this.bMinX;
                break;
            }
            case 3: {
                this.ty = this.bMinY;
                break;
            }
            case 1: {
                this.ty = this.bMaxY;
            }
        }
        this.path = new Path2D.Double();
        this.points = new ArrayList();
        this.path.moveTo(this.sx, this.sy);
        this.points.add(this.sx);
        this.points.add(this.sy);
        if (Math.abs(this.sx - this.tx) < 1.0E-5 && this.isVertical() || Math.abs(this.sy - this.ty) < 1.0E-5 && this.isHorizontal()) {
            this.lineTo(this.tx, this.ty);
            return;
        }
        this.canonicalize();
        switch (this.targetDirection) {
            case 0: {
                this.routeWest();
                break;
            }
            case 2: {
                this.routeEast();
                break;
            }
            case 3: {
                this.routeSouth();
            }
        }
        this.point(this.tx, this.ty);
    }

    private boolean isVertical() {
        return this.sourceDirection == 1 && this.targetDirection == 1 || this.sourceDirection == 3 && this.targetDirection == 3;
    }

    private boolean isHorizontal() {
        return this.sourceDirection == 0 && this.targetDirection == 0 || this.sourceDirection == 2 && this.targetDirection == 2;
    }
}

