/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor;

import org.eclipse.ui.IEditorInput;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.features.EditorNamingService2;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.workbench.IResourceEditorInput2;

public class SysdynEditorNamingService
extends EditorNamingService2 {
    public String getName(ReadGraph g, String editorId, IEditorInput in) throws DatabaseException {
        if (in instanceof IResourceEditorInput2) {
            IResourceEditorInput2 input = (IResourceEditorInput2)in;
            if (input.getRVI() != null && !input.getRVI().isEmpty()) {
                Resource model = input.getModel(g);
                if (model != null) {
                    Resource configuration = g.getPossibleObject(model, SimulationResource.getInstance((ReadGraph)g).HasConfiguration);
                    String configurationName = NameUtils.getSafeName((ReadGraph)g, (Resource)configuration);
                    String uri = String.valueOf(g.getURI(input.getModel(g))) + "/" + configurationName + input.getRVI();
                    Variable v = Variables.getPossibleVariable((ReadGraph)g, (String)uri);
                    if (v != null) {
                        String name = input.getRVI();
                        if (name.contains("/")) {
                            name = name.substring(name.lastIndexOf("/") + 1);
                        }
                        Resource instanceOf = g.getPossibleObject(v.getRepresents(g), Layer0.getInstance((ReadGraph)g).InstanceOf);
                        return String.valueOf(name) + " : " + NameUtils.getSafeName((ReadGraph)g, (Resource)instanceOf);
                    }
                }
            } else {
                ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                Resource composite = g.getPossibleObject(input.getResource(), mr.DiagramToComposite);
                if (composite != null) {
                    if (g.isInstanceOf(composite, sr.Configuration)) {
                        composite = g.getPossibleObject(composite, Layer0.getInstance((ReadGraph)g).PartOf);
                    }
                    if (composite != null) {
                        return NameUtils.getSafeName((ReadGraph)g, (Resource)composite);
                    }
                }
            }
        }
        return super.getName(g, editorId, in);
    }
}

