/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.ui.utils.VariableNameValidator;

public class VariableNode<T>
extends AbstractNode<Resource>
implements IModifiableNode {
    Variable variable;

    public VariableNode(Resource resource) {
        super((Object)resource);
    }

    public VariableNode(Variable variable, Resource represents) {
        super((Object)represents);
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public Labeler.Modifier getModifier(String columnId) {
        try {
            final Session session = Simantics.getSession();
            Resource hasName = Layer0.getInstance((RequestProcessor)session).HasName;
            LabelModifier modifier = new LabelModifier(session, (Resource)this.data, hasName){

                public String isValid(String label) {
                    if (!new VariableNameValidator().isValid((Resource)VariableNode.this.data, label)) {
                        return "Not valid";
                    }
                    return null;
                }

                public void modify(final String label) {
                    try {
                        session.syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                String originalName = (String)graph.getRelatedValue((Resource)(this).VariableNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName);
                                if (!originalName.equals(label)) {
                                    Resource configuration = graph.getPossibleObject((Resource)(this).VariableNode.this.data, Layer0.getInstance((ReadGraph)graph).PartOf);
                                    new VariableNameValidator().renameInAllEquations(graph, configuration, originalName, label);
                                    graph.claimLiteral((Resource)(this).VariableNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName, (Object)label);
                                }
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                    super.modify(label);
                }
            };
            return modifier;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

