/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDropTargetNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.FunctionLibraryNode;
import org.simantics.sysdyn.ui.utils.SharedFunctionLibraryNameValidator;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class SharedFunctionLibraryNode
extends FunctionLibraryNode<Resource>
implements IDropTargetNode {
    public SharedFunctionLibraryNode(Resource resource) {
        super(resource);
    }

    @Override
    public void delete() throws DeleteException {
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                String ontologyName = (String)graph.getPossibleRelatedValue2((Resource)SharedFunctionLibraryNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING);
                RemoverUtil.remove((WriteGraph)graph, (Resource)((Resource)SharedFunctionLibraryNode.this.data));
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Removed Shared Function Library " + ontologyName + " " + ((Resource)SharedFunctionLibraryNode.this.data).toString()));
            }
        });
    }

    @Override
    public Labeler.Modifier getModifier(String columnId) {
        try {
            Resource hasName = Layer0.getInstance((RequestProcessor)Simantics.getSession()).HasName;
            LabelModifier modifier = new LabelModifier(Simantics.getSession(), (Resource)this.data, hasName){

                public String isValid(String label) {
                    if (!new SharedFunctionLibraryNameValidator().isValid((Resource)SharedFunctionLibraryNode.this.data, label)) {
                        return "Not valid";
                    }
                    return null;
                }
            };
            return modifier;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void drop(Object data) {
        final Resource[] resources = ResourceAdaptionUtils.toResources((Object)data);
        final Resource library = (Resource)this.data;
        if (resources.length > 0) {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    Resource[] resourceArray = resources;
                    int n = resources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Resource tobeMoved = resourceArray[n2];
                        if (graph.isInstanceOf(tobeMoved, sr.SysdynModelicaFunction) || graph.isInstanceOf(tobeMoved, sr.SysdynModelicaFunctionLibrary)) {
                            graph.deny(tobeMoved, l0.PartOf);
                            graph.claim(tobeMoved, l0.PartOf, library);
                        }
                        ++n2;
                    }
                }
            });
        }
    }
}

