/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.PasteHandler;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.ui.browser.nodes.ConfigurationNode;
import org.simantics.sysdyn.ui.utils.VariableNameValidator;

public class ModuleNode
extends ConfigurationNode<Resource>
implements IModifiableNode {
    Resource configuration;

    public ModuleNode(Resource resource) {
        super(resource);
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource type = graph.getPossibleObject((Resource)ModuleNode.this.data, Layer0.getInstance((ReadGraph)graph).InstanceOf);
                ModuleNode.this.configuration = graph.getPossibleObject(type, StructuralResource2.getInstance((ReadGraph)graph).IsDefinedBy);
            }
        });
    }

    public ModuleNode(Variable variable, Resource represents) {
        super(variable, represents);
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Resource type = graph.getPossibleObject((Resource)ModuleNode.this.data, Layer0.getInstance((ReadGraph)graph).InstanceOf);
                ModuleNode.this.configuration = graph.getPossibleObject(type, StructuralResource2.getInstance((ReadGraph)graph).IsDefinedBy);
            }
        });
    }

    public Object getAdapter(Class adapter) {
        if (PasteHandler.class == adapter && this.configuration != null) {
            return new DefaultPasteHandler(this.configuration);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public Labeler.Modifier getModifier(String columnId) {
        try {
            final Session session = Simantics.getSession();
            Resource hasName = Layer0.getInstance((RequestProcessor)session).HasName;
            LabelModifier modifier = new LabelModifier(session, (Resource)this.data, hasName){

                public String isValid(String label) {
                    if (!new VariableNameValidator().isValid((Resource)ModuleNode.this.data, label)) {
                        return "Not valid";
                    }
                    return null;
                }

                public void modify(final String label) {
                    try {
                        session.syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                String originalName = (String)graph.getRelatedValue((Resource)(this).ModuleNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName);
                                if (!originalName.equals(label)) {
                                    Resource configuration = graph.getPossibleObject((Resource)(this).ModuleNode.this.data, Layer0.getInstance((ReadGraph)graph).PartOf);
                                    new VariableNameValidator().renameInAllEquations(graph, configuration, originalName, label);
                                    graph.claimLiteral((Resource)(this).ModuleNode.this.data, Layer0.getInstance((ReadGraph)graph).HasName, (Object)label);
                                }
                            }
                        });
                    }
                    catch (DatabaseException e) {
                        e.printStackTrace();
                    }
                    super.modify(label);
                }
            };
            return modifier;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

