/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.rules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.IFunction;
import org.simantics.objmap.IMappingRule;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.rules.domain.IDomainAccessor;
import org.simantics.objmap.rules.range.IRangeAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueRule
implements IMappingRule {
    static Logger LOGGER = LoggerFactory.getLogger((String)"org.simantics.objmap");
    IDomainAccessor<Object> domainAccessor;
    IRangeAccessor<Object> rangeAccessor;

    public ValueRule(IDomainAccessor<Object> domainAccessor, IRangeAccessor<Object> rangeAccessor) {
        this.domainAccessor = domainAccessor;
        this.rangeAccessor = rangeAccessor;
    }

    @Override
    public boolean updateDomain(WriteGraph g, IFunction<Object, Resource> map, Resource domainElement, Object rangeElement) throws MappingException {
        LOGGER.trace("    ValueRule.updateDomain");
        Object value = this.rangeAccessor.get(rangeElement);
        return this.domainAccessor.set(g, domainElement, value);
    }

    @Override
    public boolean updateRange(ReadGraph g, IFunction<Resource, Object> map, Resource domainElement, Object rangeElement) throws MappingException {
        LOGGER.trace("    ValueRule.updateRange");
        Object value = this.domainAccessor.get(g, domainElement);
        return this.rangeAccessor.set(rangeElement, value);
    }
}

