/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.impl;

import gnu.trove.map.hash.THashMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.IFunction;
import org.simantics.objmap.ILinkType;
import org.simantics.objmap.IMapping;
import org.simantics.objmap.IMappingListener;
import org.simantics.objmap.IMappingSchema;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.impl.Link;

public class UnidirectionalMapping
implements IMapping {
    IMappingSchema schema;
    THashMap<Resource, Link> domain = new THashMap();
    ArrayList<IMappingListener> listeners = new ArrayList();
    ArrayList<Link> modifiedDomainLinks = new ArrayList();
    boolean disposed = false;
    Set<Resource> domainSet = new AbstractSet<Resource>(){

        @Override
        public boolean add(Resource e) {
            if (UnidirectionalMapping.this.domain.containsKey((Object)e)) {
                return false;
            }
            Link link = new Link(null, e, null);
            UnidirectionalMapping.this.domain.put((Object)e, (Object)link);
            UnidirectionalMapping.this.modifiedDomainLinks.add(link);
            return true;
        }

        @Override
        public boolean contains(Object o) {
            return UnidirectionalMapping.this.domain.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            Link link = (Link)UnidirectionalMapping.this.domain.remove(o);
            if (link == null) {
                return false;
            }
            UnidirectionalMapping.this.removeLink(link);
            return true;
        }

        @Override
        public Iterator<Resource> iterator() {
            return UnidirectionalMapping.this.domain.keySet().iterator();
        }

        @Override
        public int size() {
            return UnidirectionalMapping.this.domain.size();
        }
    };

    public UnidirectionalMapping(IMappingSchema schema) {
        this.schema = schema;
    }

    private void removeLink(Link link) {
        if (link.domainModified) {
            this.modifiedDomainLinks.remove(link);
        }
        link.removed = true;
    }

    private void createDomain(WriteGraph g, Link link) throws MappingException {
        ILinkType type = this.schema.linkTypeOfRangeElement(link.rangeElement);
        Resource domainElement = type.createDomainElement(g, link.rangeElement);
        link.type = type;
        link.domainElement = domainElement;
        this.domain.put((Object)domainElement, (Object)link);
    }

    private void createRange(ReadGraph g, Link link) throws MappingException {
        ILinkType type = this.schema.linkTypeOfDomainElement(g, link.domainElement);
        Object rangeElement = type.createRangeElement(g, link.domainElement);
        link.type = type;
        link.rangeElement = rangeElement;
    }

    @Override
    public Set<Resource> getDomain() {
        return this.domainSet;
    }

    @Override
    public Set<Object> getRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Resource> updateDomain(WriteGraph g) throws MappingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> updateRange(ReadGraph g) throws MappingException {
        DomainToRange map = new DomainToRange(g);
        ArrayList<Object> updated = new ArrayList<Object>();
        while (!this.modifiedDomainLinks.isEmpty()) {
            Link link = this.modifiedDomainLinks.remove(this.modifiedDomainLinks.size() - 1);
            link.domainModified = false;
            if (link.type == null) {
                this.createRange(g, link);
            }
            link.type.updateRange(g, map, link.domainElement, link.rangeElement);
            updated.add(link.rangeElement);
        }
        return updated;
    }

    @Override
    public Object get(Resource domainElement) {
        Link link = (Link)this.domain.get((Object)domainElement);
        if (link == null) {
            return null;
        }
        return link.rangeElement;
    }

    @Override
    public Resource inverseGet(Object rangeElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Resource inverseMap(WriteGraph g, Object rangeElement) throws MappingException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object map(ReadGraph g, Resource domainElement) throws MappingException {
        this.getDomain().add(domainElement);
        this.updateRange(g);
        return this.get(domainElement);
    }

    void domainModified(Link link) {
        if (!link.domainModified) {
            link.domainModified = true;
            this.modifiedDomainLinks.add(link);
            if (this.modifiedDomainLinks.size() == 1) {
                for (IMappingListener listener : this.listeners) {
                    listener.domainModified();
                }
            }
        }
    }

    @Override
    public void domainModified(Resource domainElement) {
        Link link = (Link)this.domain.get((Object)domainElement);
        if (link != null) {
            this.domainModified(link);
        }
    }

    @Override
    public boolean isDomainModified() {
        return !this.modifiedDomainLinks.isEmpty();
    }

    @Override
    public boolean isRangeModified() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addMappingListener(IMappingListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeMappingListener(IMappingListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Collection<Resource> getConflictingDomainElements() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Object> getConflictingRangeElements() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public void rangeModified(Object rangeElement) {
        throw new UnsupportedOperationException();
    }

    class DomainToRange
    implements IFunction<Resource, Object> {
        ReadGraph g;

        public DomainToRange(ReadGraph g) {
            this.g = g;
        }

        @Override
        public Object get(Resource element) throws MappingException {
            Link link = (Link)UnidirectionalMapping.this.domain.get((Object)element);
            if (link == null) {
                ILinkType type = UnidirectionalMapping.this.schema.linkTypeOfDomainElement(this.g, element);
                Object rangeElement = type.createRangeElement(this.g, element);
                link = new Link(type, element, rangeElement);
                UnidirectionalMapping.this.domain.put((Object)element, (Object)link);
                link.domainModified = true;
                UnidirectionalMapping.this.modifiedDomainLinks.add(link);
                return rangeElement;
            }
            if (link.type == null) {
                UnidirectionalMapping.this.createRange(this.g, link);
            }
            return link.rangeElement;
        }
    }
}

