/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties.xyline;

import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.jfreechart.chart.properties.xyline.AxisAndVariablesExplorerComposite;
import org.simantics.jfreechart.chart.properties.xyline.AxisPropertyComposite;
import org.simantics.jfreechart.chart.properties.xyline.SeriesPropertyComposite;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.AdaptionUtils;

public class XYLineAxisAndVariablesTab
extends AdjustableTab {
    private GraphExplorerComposite explorer;
    private ScrolledComposite propertyContainer;
    private Button addAxis;
    private Button addVariable;
    private Button remove;
    private WidgetSupportImpl additionalSupport = new WidgetSupportImpl();
    private Composite buttonComposite;

    public XYLineAxisAndVariablesTab(Object id) {
        super(id);
    }

    private void updateSelection(ISessionContext context) {
        ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        final Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
        if (resource == null) {
            return;
        }
        String typeUri = null;
        try {
            typeUri = (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                    if (graph.isInstanceOf(resource, jfree.Axis)) {
                        return graph.getURI(jfree.Axis);
                    }
                    if (graph.isInstanceOf(resource, jfree.Series)) {
                        return graph.getURI(jfree.Series);
                    }
                    return null;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        if (typeUri != null) {
            Control[] controlArray = this.propertyContainer.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.dispose();
                ++n2;
            }
            if (typeUri.equals("http://www.simantics.org/JFreeChart-1.0/Axis")) {
                AxisPropertyComposite apc = new AxisPropertyComposite((Composite)this.propertyContainer, context, (WidgetSupport)this.additionalSupport, 0, this.isVertical());
                this.propertyContainer.setContent((Control)apc);
                Point size = apc.computeSize(-1, -1);
                this.propertyContainer.setMinSize(size);
            } else if (typeUri.equals("http://www.simantics.org/JFreeChart-1.0/Series")) {
                SeriesPropertyComposite spc = new SeriesPropertyComposite((Composite)this.propertyContainer, context, (WidgetSupport)this.additionalSupport, 0);
                this.propertyContainer.setContent((Control)spc);
                Point size = spc.computeSize(-1, -1);
                this.propertyContainer.setMinSize(size);
            }
        }
        this.additionalSupport.fireInput(context, (Object)selection);
    }

    @Override
    protected void createAndAddControls(Composite body, IWorkbenchSite site, final ISessionContext context, WidgetSupport support) {
        this.composite = new Composite(body, 0);
        this.explorer = new AxisAndVariablesExplorerComposite((Map<String, Object>)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, this.composite, support, 67588);
        this.explorer.setBrowseContexts(new String[]{"http://www.simantics.org/JFreeChart-1.0/ChartAxisAndVariablesBrowseContext"});
        this.explorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.explorer.getExplorer().setAutoExpandLevel(2);
        this.explorer.finish();
        ((Tree)this.explorer.getExplorerControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XYLineAxisAndVariablesTab.this.updateSelection(context);
            }
        });
        this.propertyContainer = new ScrolledComposite(this.composite, 768);
        this.propertyContainer.setExpandHorizontal(true);
        this.propertyContainer.setExpandVertical(true);
        this.buttonComposite = new Composite(this.composite, 0);
        this.addAxis = new Button(this.buttonComposite, support, 0);
        this.addAxis.setText("Add axis");
        this.addAxis.addSelectionListener((SelectionListener)new NewAxisListener(context));
        this.addVariable = new Button(this.buttonComposite, (WidgetSupport)this.additionalSupport, 0);
        this.addVariable.setText("Add variable");
        this.addVariable.addSelectionListener((SelectionListener)new NewVariableListener(context));
        this.remove = new Button(this.buttonComposite, (WidgetSupport)this.additionalSupport, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new RemoveListener(context));
    }

    @Override
    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().hint(220, -1).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().hint(-1, 210).span(1, 1).grab(true, false).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
        GridDataFactory.fillDefaults().applyTo((Control)this.buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.buttonComposite);
    }

    @Override
    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().hint(250, -1).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().hint(-1, -1).span(1, 2).grab(true, true).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
        GridDataFactory.fillDefaults().applyTo((Control)this.buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.buttonComposite);
    }

    private class NewAxisListener
    extends SelectionListenerImpl<Resource> {
        public NewAxisListener(ISessionContext context) {
            super(context);
        }

        public void apply(WriteGraph graph, Resource chart) throws DatabaseException {
            Resource rangeAxis;
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.Plot));
            if (plot != null && (rangeAxis = ChartUtils.createNumberRangeAxis(graph, plot)) != null) {
                Resource domainAxis = graph.getPossibleObject(plot, jfree.Plot_domainAxis);
                ChartUtils.createXYDataset(graph, plot, domainAxis, rangeAxis);
            }
        }
    }

    private class NewVariableListener
    extends SelectionListenerImpl<Resource> {
        public NewVariableListener(ISessionContext context) {
            super(context);
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            Resource dataset;
            Resource plot;
            NodeContext nc = XYLineAxisAndVariablesTab.this.explorer.getExplorer().getRoot();
            if (nc == null) {
                return;
            }
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            if (input == null) {
                Resource chart = (Resource)AdaptionUtils.adaptToSingle((Object)nc, Resource.class);
                if (chart == null) {
                    return;
                }
                plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, l0.ConsistsOf, jfree.Plot));
                if (plot == null) {
                    return;
                }
                Resource rangelist = graph.getPossibleObject(plot, jfree.Plot_rangeAxisList);
                if (rangelist == null) {
                    return;
                }
                List list = ListUtils.toList((ReadGraph)graph, (Resource)rangelist);
                if (list == null || list.isEmpty()) {
                    return;
                }
                input = (Resource)list.get(0);
            }
            if (graph.isInstanceOf(input, jfree.Series)) {
                dataset = graph.getPossibleObject(input, l0.PartOf);
            } else {
                dataset = graph.getPossibleObject(input, jfree.Dataset_mapToRangeAxis_Inverse);
                if (dataset == null) {
                    plot = graph.getPossibleObject(input, l0.PartOf);
                    if (plot == null) {
                        return;
                    }
                    Resource domainAxis = graph.getPossibleObject(plot, jfree.Plot_domainAxis);
                    if (domainAxis == null) {
                        return;
                    }
                    ChartUtils.createXYDataset(graph, plot, domainAxis, input);
                }
            }
            if (dataset != null) {
                ChartUtils.createSeries(graph, dataset, null);
            }
        }
    }

    private class RemoveListener
    extends SelectionListenerImpl<Resource> {
        public RemoveListener(ISessionContext context) {
            super(context);
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            if (input == null) {
                return;
            }
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource list = null;
            if (graph.isInstanceOf(input, jfree.Series)) {
                Resource dataset = graph.getPossibleObject(input, l0.PartOf);
                if (dataset != null) {
                    list = graph.getPossibleObject(dataset, jfree.Dataset_seriesList);
                }
            } else {
                Resource plot;
                Resource dataset = graph.getPossibleObject(input, jfree.Dataset_mapToRangeAxis_Inverse);
                if (dataset != null) {
                    graph.deny(dataset, jfree.Dataset_mapToDomainAxis);
                    graph.deny(dataset, jfree.Dataset_mapToRangeAxis);
                    RemoverUtil.remove((WriteGraph)graph, (Resource)dataset);
                }
                if ((plot = graph.getPossibleObject(input, l0.PartOf)) != null) {
                    list = graph.getPossibleObject(plot, jfree.Plot_rangeAxisList);
                }
            }
            if (list != null) {
                ListUtils.removeElement((WriteGraph)graph, (Resource)list, (Resource)input);
            }
            RemoverUtil.remove((WriteGraph)graph, (Resource)input);
        }
    }
}

