/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.jfreechart.chart.properties.VariableProposalProvider;

public class RVIModifier
extends TextModifyListenerImpl<Resource> {
    private boolean active;
    private Control control;
    private String rviUri;
    private String indexUri;
    private char[] alphaNumericCharacters = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\ufffd', '\ufffd', '\ufffd', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\ufffd', '\ufffd', '\ufffd', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '.'};

    public RVIModifier(Control control, WidgetSupport support) {
        this(control, support, "http://www.simantics.org/JFreeChart-1.0/variableRVI", "http://www.simantics.org/JFreeChart-1.0/variableFilter");
    }

    public RVIModifier(Control control, WidgetSupport support, String rviRelationUri, String indexUri) {
        this.rviUri = rviRelationUri;
        this.indexUri = indexUri;
        this.control = control;
        this.active = true;
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        VariableProposalProvider scpp = new VariableProposalProvider(control, support);
        scpp.setFiltering(true);
        ContentProposalAdapter adapter = new ContentProposalAdapter(control, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)scpp, keyStroke, this.alphaNumericCharacters);
        adapter.setAutoActivationDelay(0);
        adapter.setProposalAcceptanceStyle(2);
        adapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                if (RVIModifier.this != null) {
                    RVIModifier.this.deactivate();
                }
            }

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
                if (RVIModifier.this != null) {
                    RVIModifier.this.activate();
                }
            }
        });
        adapter.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal proposal) {
                if (RVIModifier.this.control != null && !RVIModifier.this.control.isDisposed()) {
                    RVIModifier.this.modifyText(new TrackedModifyEvent((Widget)RVIModifier.this.control, proposal.getContent()));
                }
            }
        });
    }

    public void applyText(WriteGraph graph, Resource resource, String text) throws DatabaseException {
        if (this.active) {
            text = "/" + text.replace('.', '/');
            graph.claimLiteral(resource, this.getRVIRelation((ReadGraph)graph), (Object)text, (Binding)Bindings.STRING);
            graph.deny(resource, this.getIndexRelation((ReadGraph)graph));
        }
    }

    private Resource getRVIRelation(ReadGraph graph) throws DatabaseException {
        return graph.getResource(this.rviUri);
    }

    private Resource getIndexRelation(ReadGraph graph) throws DatabaseException {
        return graph.getResource(this.indexUri);
    }

    public void deactivate() {
        this.active = false;
    }

    public void activate() {
        this.active = true;
    }
}

