/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.awt.Color;
import java.util.Arrays;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.RunnableWithObject;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.gfx.ColorImageDescriptor;

public class ColorPicker
extends Composite
implements Widget {
    Button defaultColor;
    Button customColor;
    Button color;

    public ColorPicker(Composite parent, ISessionContext context, WidgetSupport support, int style) {
        this(parent, context, support, style, true);
    }

    public ColorPicker(Composite parent, ISessionContext context, WidgetSupport support, int style, boolean defaultColor) {
        super(parent, style);
        support.register((Widget)this);
        if (support.getParameter("resourceManager") == null) {
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this);
            support.setParameter("resourceManager", (Object)resourceManager);
        }
        if (defaultColor) {
            GridLayoutFactory.fillDefaults().numColumns(4).applyTo((Composite)this);
            this.defaultColor = new Button((Composite)this, support, 16);
            this.defaultColor.setText("default");
            this.defaultColor.setSelectionFactory((ReadFactory)new DefaultColorSelectionFactory(false));
            this.defaultColor.addSelectionListener((SelectionListener)new DefaultColorSelectionListener(context));
            GridDataFactory.fillDefaults().applyTo((Control)this.defaultColor.getWidget());
            this.customColor = new Button((Composite)this, support, 16);
            this.customColor.setText("custom");
            this.customColor.setSelectionFactory((ReadFactory)new DefaultColorSelectionFactory(true));
            this.customColor.addSelectionListener((SelectionListener)new DefaultColorSelectionListener(context));
            GridDataFactory.fillDefaults().applyTo((Control)this.customColor.getWidget());
        } else {
            GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        }
        this.color = new Button((Composite)this, support, 8);
        this.color.setImageFactory((ReadFactory)new ColorImageFactoryFactory(this));
        this.color.addSelectionListener((SelectionListener)new ColorSelectionListener(context));
        this.color.getWidget().setEnabled(false);
        GridDataFactory.fillDefaults().applyTo((Control)this.color.getWidget());
    }

    protected Resource getResource(ReadGraph graph, Resource input) throws DatabaseException {
        return input;
    }

    protected Resource getColorRelation(ReadGraph graph) throws DatabaseException {
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        return jfree.color;
    }

    public void setInput(ISessionContext context, Object input) {
        final Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        context.getSession().asyncRequest((Read)new Read<Float[]>(){

            public Float[] perform(ReadGraph graph) throws DatabaseException {
                if (graph.hasStatement(ColorPicker.this.getResource(graph, resource), ColorPicker.this.getColorRelation(graph))) {
                    float[] components = (float[])graph.getPossibleRelatedValue(ColorPicker.this.getResource(graph, resource), ColorPicker.this.getColorRelation(graph));
                    Float[] result = new Float[components.length];
                    int i = 0;
                    while (i < components.length) {
                        result[i] = Float.valueOf(components[i]);
                        ++i;
                    }
                    return result;
                }
                return null;
            }
        }, (Listener)new Listener<Float[]>(){

            public void execute(Float[] result) {
                if (!ColorPicker.this.color.getWidget().isDisposed()) {
                    ColorPicker.this.color.getWidget().getDisplay().asyncExec((Runnable)new RunnableWithObject(result != null){

                        public void run() {
                            if (!(this).ColorPicker.this.color.getWidget().isDisposed()) {
                                if (!Boolean.TRUE.equals(this.getObject())) {
                                    (this).ColorPicker.this.color.getWidget().setEnabled(false);
                                } else {
                                    (this).ColorPicker.this.color.getWidget().setEnabled(true);
                                }
                            }
                        }
                    });
                }
            }

            public void exception(Throwable t) {
                t.printStackTrace();
            }

            public boolean isDisposed() {
                return ColorPicker.this.color.getWidget().isDisposed();
            }
        });
    }

    private RGB getColor(ReadGraph graph, Resource input) throws DatabaseException {
        float[] colorComponents = (float[])graph.getPossibleRelatedValue(input, this.getColorRelation(graph));
        RGB rgb = colorComponents == null ? new RGB(0, 0, 255) : new RGB((int)(colorComponents[0] * 255.0f), (int)(colorComponents[1] * 255.0f), (int)(colorComponents[2] * 255.0f));
        return rgb;
    }

    private class ColorImageFactoryFactory
    extends ReadFactoryImpl<Resource, ImageDescriptor> {
        private ColorPicker picker;

        public ColorImageFactoryFactory(ColorPicker colorPicker2) {
            this.picker = colorPicker2;
        }

        public ImageDescriptor perform(ReadGraph graph, Resource input) throws DatabaseException {
            RGB rgb = ColorPicker.this.getColor(graph, ColorPicker.this.getResource(graph, input));
            return new ColorImageDescriptor(rgb.red, rgb.green, rgb.blue, 20, 20, false);
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, (Object)this.picker, ((Object)((Object)this)).getClass());
        }
    }

    private class ColorSelectionListener
    extends SelectionListenerImpl<Resource> {
        private SelectionEvent e;
        private RGB rgb;

        public ColorSelectionListener(ISessionContext context) {
            super(context);
        }

        public void widgetSelected(SelectionEvent e) {
            if (ColorPicker.this.color.getWidget().isDisposed()) {
                return;
            }
            this.e = e;
            super.widgetSelected(e);
        }

        public void beforeApply(final Resource input) {
            try {
                RGB oldRGB = (RGB)Simantics.getSession().syncRequest((Read)new UniqueRead<RGB>(){

                    public RGB perform(ReadGraph graph) throws DatabaseException {
                        Resource resource = ColorPicker.this.getResource(graph, input);
                        return ColorPicker.this.getColor(graph, resource);
                    }
                });
                Display display = ColorPicker.this.color.getWidget().getDisplay();
                Shell shell = new Shell(display);
                ColorDialog cd = new ColorDialog(shell);
                Point point = ColorPicker.this.color.getWidget().toDisplay(this.e.x - 150, this.e.y - 150);
                cd.getParent().setLocation(point.x, point.y);
                cd.setText("Select color");
                cd.setRGB(oldRGB);
                this.rgb = cd.open();
                if (this.rgb == null) {
                    return;
                }
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
            float[] components = new float[]{(float)this.rgb.red / 255.0f, (float)this.rgb.green / 255.0f, (float)this.rgb.blue / 255.0f, 1.0f};
            Resource resource = ColorPicker.this.getResource((ReadGraph)graph, input);
            float[] currentComponents = (float[])graph.getPossibleRelatedValue2(resource, ColorPicker.this.getColorRelation((ReadGraph)graph));
            if (currentComponents == null || !Arrays.equals(components, currentComponents)) {
                graph.claimLiteral(resource, ColorPicker.this.getColorRelation((ReadGraph)graph), g2d.Color, (Object)components);
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified color of " + NameUtils.getSafeName((ReadGraph)graph, (Resource)resource) + " to " + Arrays.toString(components)));
            }
        }
    }

    private class DefaultColorSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        private final Boolean isCustom;

        public DefaultColorSelectionFactory(Boolean isCustom) {
            this.isCustom = isCustom;
        }

        public Object getIdentity(Object inputContents) {
            return new Triple((Object)((Resource)inputContents), ((Object)((Object)this)).getClass(), (Object)this.isCustom);
        }

        public Boolean perform(ReadGraph graph, Resource input) throws DatabaseException {
            Resource r = graph.getPossibleObject(ColorPicker.this.getResource(graph, input), ColorPicker.this.getColorRelation(graph));
            boolean result = false;
            if (r == null && !this.isCustom.booleanValue()) {
                result = true;
            } else if (r != null && this.isCustom.booleanValue()) {
                result = true;
            }
            return result;
        }
    }

    private class DefaultColorSelectionListener
    extends SelectionListenerImpl<Resource> {
        private SelectionEvent e;

        public DefaultColorSelectionListener(ISessionContext context) {
            super(context);
        }

        public void widgetSelected(SelectionEvent e) {
            this.e = e;
            super.widgetSelected(e);
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            Resource resource = ColorPicker.this.getResource((ReadGraph)graph, input);
            if (ColorPicker.this.customColor.getWidget().equals(this.e.widget)) {
                G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
                if (graph.getPossibleObject(resource, ColorPicker.this.getColorRelation((ReadGraph)graph)) == null) {
                    float[] components = Color.BLUE.getColorComponents(new float[4]);
                    components[3] = 1.0f;
                    graph.claimLiteral(resource, ColorPicker.this.getColorRelation((ReadGraph)graph), g2d.Color, (Object)components);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Color for " + graph.getPossibleRelatedValue2(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " set to custom "));
                }
            } else {
                Resource o = graph.getPossibleObject(resource, ColorPicker.this.getColorRelation((ReadGraph)graph));
                if (o != null) {
                    graph.deny(resource, ColorPicker.this.getColorRelation((ReadGraph)graph));
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Color for " + graph.getPossibleRelatedValue2(resource, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING) + " set to Default"));
                }
            }
        }
    }
}

