/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import org.jfree.chart.title.Title;
import org.jfree.chart.ui.RectangleEdge;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.jfreechart.chart.ITitle;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;

public class TextTitle
implements ITitle {
    private org.jfree.chart.title.TextTitle textTitle;
    private RectangleEdge position;
    private String text;
    private Boolean visible;

    public TextTitle(ReadGraph graph, Resource titleResource) {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        try {
            this.text = (String)graph.getPossibleRelatedValue(titleResource, l0.HasLabel, (Binding)Bindings.STRING);
            Resource pos = graph.getPossibleObject(titleResource, jfree.Title_position);
            this.position = this.getRectangleEdgePosition(graph, pos);
            this.visible = (Boolean)graph.getPossibleRelatedValue(titleResource, jfree.visible, (Binding)Bindings.BOOLEAN);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private RectangleEdge getRectangleEdgePosition(ReadGraph graph, Resource position) {
        if (position == null) {
            return null;
        }
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        if (position.equals(jfree.Top)) {
            return RectangleEdge.TOP;
        }
        if (position.equals(jfree.Bottom)) {
            return RectangleEdge.BOTTOM;
        }
        if (position.equals(jfree.Left)) {
            return RectangleEdge.LEFT;
        }
        if (position.equals(jfree.Right)) {
            return RectangleEdge.RIGHT;
        }
        return null;
    }

    @Override
    public Title getTitle() {
        this.textTitle = new org.jfree.chart.title.TextTitle(this.text);
        if (this.position != null) {
            this.textTitle.setPosition(this.position);
        }
        if (this.visible != null) {
            this.textTitle.setVisible(this.visible.booleanValue());
        }
        return this.textTitle;
    }

    @Override
    public void dispose() {
    }
}

