/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartColor;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.DefaultXYDataset;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.AbstractDataset;
import org.simantics.jfreechart.chart.ConstantXYDatasetRequest;
import org.simantics.jfreechart.chart.ConstantXYDatasetSeries;
import org.simantics.jfreechart.chart.IRenderer;
import org.simantics.jfreechart.chart.XYDataset;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.datastructures.Pair;

public class ConstantXYDataSet
extends AbstractDataset
implements XYDataset {
    protected IRenderer renderer;
    protected Dataset dataset;
    protected DisposableListener<?> datasetListener;

    public ConstantXYDataSet(Resource datasetResource) throws DatabaseException {
        super(datasetResource);
    }

    @Override
    public Dataset getDataset() {
        if (this.dataset == null) {
            this.dataset = new DefaultXYDataset();
        }
        if (this.datasetListener == null || this.datasetListener.isDisposed()) {
            this.datasetListener = new DataSetListener();
            Simantics.getSession().asyncRequest((Read)new ConstantXYDatasetRequest(this.resource), this.datasetListener);
        }
        return this.dataset;
    }

    @Override
    public void dispose() {
        if (this.datasetListener != null) {
            this.datasetListener.dispose();
            this.datasetListener = null;
        }
    }

    @Override
    public AbstractRenderer getRenderer() {
        if (this.renderer == null) {
            try {
                this.renderer = (IRenderer)Simantics.getSession().syncRequest((Read)new Read<IRenderer>(){

                    public IRenderer perform(ReadGraph graph) throws DatabaseException {
                        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                        IRenderer renderer = null;
                        Resource rendererResource = graph.getPossibleObject(ConstantXYDataSet.this.resource, jfree.Dataset_renderer);
                        if (rendererResource != null) {
                            renderer = (IRenderer)graph.adapt(rendererResource, IRenderer.class);
                        }
                        return renderer;
                    }
                });
            }
            catch (DatabaseException databaseException) {}
            if (this.renderer == null) {
                XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
                renderer.setDefaultToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
                return renderer;
            }
            return this.renderer.getRenderer();
        }
        return this.renderer.getRenderer();
    }

    private class DataSetListener
    extends DisposableListener<Pair<ArrayList<ConstantXYDatasetSeries>, IRenderer>> {
        private DataSetListener() {
        }

        public void execute(Pair<ArrayList<ConstantXYDatasetSeries>, IRenderer> result) {
            final ArrayList series = (ArrayList)result.first;
            ConstantXYDataSet.this.renderer = (IRenderer)result.second;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((DataSetListener)DataSetListener.this).ConstantXYDataSet.this.dataset == null || !(((DataSetListener)DataSetListener.this).ConstantXYDataSet.this.dataset instanceof DefaultXYDataset)) {
                        return;
                    }
                    DefaultXYDataset ds = (DefaultXYDataset)((DataSetListener)DataSetListener.this).ConstantXYDataSet.this.dataset;
                    XYPlot plot = ((AbstractXYItemRenderer)ConstantXYDataSet.this.getRenderer()).getPlot();
                    if (plot != null) {
                        Paint[] paintSequence = ChartColor.createDefaultPaintArray();
                        paintSequence[3] = new Color(255, 221, 0);
                        DefaultDrawingSupplier drawingsupplier = new DefaultDrawingSupplier(paintSequence, DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
                        plot.setDrawingSupplier((DrawingSupplier)drawingsupplier);
                    }
                    int i = ds.getSeriesCount() - 1;
                    while (i >= 0) {
                        ds.removeSeries(ds.getSeriesKey(i));
                        --i;
                    }
                    i = 0;
                    while (i < series.size()) {
                        ConstantXYDatasetSeries s = (ConstantXYDatasetSeries)series.get(i);
                        String name = s.name;
                        if (ds.indexOf((Comparable)((Object)name)) >= 0) {
                            name = String.valueOf(name) + (i + 1);
                        }
                        ds.addSeries((Comparable)((Object)name), s.values);
                        ConstantXYDataSet.this.getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(s.width));
                        ConstantXYDataSet.this.getRenderer().setSeriesPaint(i, (Paint)s.color);
                        ++i;
                    }
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }
    }
}

