/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.Argument;
import fi.semantum.sysdyn.solver.Array;
import fi.semantum.sysdyn.solver.Constant;
import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ForArray
implements IExpression {
    private ArrayList<Object> elements = new ArrayList();

    public ForArray() {
    }

    public ForArray(ArrayList<Object> elements) {
        this.elements = elements;
    }

    public void addElement(Object element) {
        if (element instanceof Constant) {
            this.addElement(((Constant)element).value);
        } else {
            this.elements.add(element);
        }
    }

    public void setElement(int index, Object element) {
        this.elements.set(index, element);
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        return this.evaluated(environment);
    }

    public Array evaluated(IEnvironment environment) {
        Array result = new Array();
        IExpression exp = (IExpression)this.elements.get(0);
        Argument arg = (Argument)this.elements.get(1);
        Array indices = (Array)arg.modification.evaluate(environment);
        for (Object o : indices.elements()) {
            environment.put(arg.name, o);
            result.addElement(exp.evaluate(environment));
        }
        return result;
    }

    public String toString() {
        return this.elements.toString();
    }

    public int size(int col) {
        return this.elements.size();
    }

    public Object element(int index) {
        return this.elements.get(index);
    }

    public Collection<Object> elements() {
        return this.elements;
    }

    public void ensureIndex(int index, boolean subArray) {
        int needed = index + 1 - this.elements.size();
        int i = 0;
        while (i < needed) {
            this.addElement(subArray ? new ForArray() : null);
            ++i;
        }
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        ArrayList<Object> e = new ArrayList<Object>();
        for (Object o : this.elements) {
            if (o instanceof IExpression) {
                e.add(((IExpression)o).withBase(frame, prefix));
                continue;
            }
            e.add(o);
        }
        return new ForArray(e);
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        int i = 0;
        while (i < this.elements.size()) {
            Object o = this.elements.get(i);
            if (o instanceof IExpression) {
                this.elements.set(i, ((IExpression)o).rewrite(frame, copies));
            }
            ++i;
        }
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        int i = 0;
        while (i < this.elements.size()) {
            Object o = this.elements.get(i);
            if (o instanceof IExpression) {
                ((IExpression)o).accept(visitor);
            }
            ++i;
        }
    }
}

