/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.search;

import java.io.File;
import java.util.Collection;
import java.util.TreeMap;
import org.simantics.workbench.search.NamedResource;
import org.simantics.workbench.search.SearchEngine;
import org.simantics.workbench.search.SearchParam;
import org.simantics.workbench.search.SearchQuery;
import org.simantics.workbench.search.SearchResult;

public class SearchData {
    int resultNumber;
    String dataUrl;
    File dataDirectory;
    SearchQuery query;
    NamedResource model;
    SearchEngine searchEngine;
    SearchResult results;
    Collection<SearchEngine> searchEngines;
    int resultCount;
    int maxResults;

    public int getResultNumber() {
        return this.resultNumber;
    }

    public String getDataUrl() {
        return this.dataUrl;
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public SearchQuery getQuery() {
        return this.query;
    }

    public Collection<SearchEngine> getSearchEngines() {
        return this.searchEngines;
    }

    public Collection<SearchParam> getAllSearchParams() {
        TreeMap<String, SearchParam> params = new TreeMap<String, SearchParam>();
        for (SearchEngine engine : this.searchEngines) {
            for (SearchParam param : engine.getSupportedParams()) {
                params.put(param.getName(), param);
            }
        }
        return params.values();
    }

    public NamedResource getModel() {
        return this.model;
    }

    public SearchResult getResults() {
        return this.results;
    }

    public int getResultCount() {
        return this.results.rows.size();
    }

    public int getResultTotalCount() {
        return this.resultCount;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public SearchData clone() {
        SearchData data = new SearchData();
        data.resultNumber = this.resultNumber;
        data.dataUrl = this.dataUrl;
        data.dataDirectory = this.dataDirectory;
        data.query = this.query;
        data.model = this.model;
        data.results = this.results;
        data.maxResults = this.maxResults;
        data.resultCount = this.resultCount;
        data.searchEngine = this.searchEngine;
        data.searchEngines = this.searchEngines;
        return data;
    }
}

