/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.wiki.ui.editor;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.SWT;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.EditorPart;

public class WikiPrintAction extends Action {

	final IPrintable printable;

	public WikiPrintAction(IPrintable printable) {
		this.printable = printable;
	}

	public void run() {
		if(!(printable instanceof EditorPart)) return;
		Shell shell = ((EditorPart)printable).getEditorSite().getShell();

		final PrintDialog dialog = new PrintDialog(shell, SWT.PRIMARY_MODAL);
		final PrinterData data = dialog.open();

		if (data != null) {
			final Printer printer = new Printer(data);

			Thread printingThread = new Thread("Printing") { //$NON-NLS-1$
				public void run() {
					printable.print(printer);
				}
			};
			printingThread.start();
		}
		return;
	}
}
