/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.nebula;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.utils.ui.nebula.SelectionListenerUtil;

public class NebulaSlider
extends Canvas {
    private int H_MARGIN = 5;
    private int SELECTOR_WIDTH = 78;
    private int BAR_HEIGHT = 12;
    private int SELECTOR_HEIGHT = 32;
    private final Color barInsideColor;
    private final Color barBorderColor;
    private final Color barSelectionColor;
    private final Color selectorColor;
    private final Color selectorColorBorder;
    private final Color selectorTextColor;
    private final Color arrowColor;
    private int minimum;
    private int maximum;
    private int value;
    private int xPosition;
    private int mouseDeltaX;
    private final Font textFont;
    private boolean moving = false;

    public NebulaSlider(Composite parent, int style) {
        super(parent, NebulaSlider.checkStyle(style) | 0x20000000);
        this.barInsideColor = this.getAndDisposeColor(225, 225, 225);
        this.barBorderColor = this.getAndDisposeColor(211, 211, 211);
        this.barSelectionColor = this.getAndDisposeColor(41, 128, 185);
        this.selectorColor = this.getAndDisposeColor(52, 152, 219);
        this.selectorColorBorder = this.getAndDisposeColor(224, 237, 245);
        this.selectorTextColor = this.getAndDisposeColor(255, 255, 255);
        this.arrowColor = this.getAndDisposeColor(153, 203, 237);
        this.minimum = Integer.MIN_VALUE;
        this.maximum = Integer.MAX_VALUE;
        this.value = 0;
        this.xPosition = -1;
        this.textFont = this.createTextFont();
        this.addPaintListener(e -> this.paintControl(e.gc));
        this.addMouseListeners();
    }

    public NebulaSlider(Composite parent, int SELECTOR_WIDTH, int SELECTOR_HEIGHT, int BAR_HEIGHT, int H_MARGIN, int style) {
        super(parent, NebulaSlider.checkStyle(style) | 0x20000000);
        this.H_MARGIN = H_MARGIN;
        this.SELECTOR_WIDTH = SELECTOR_WIDTH;
        this.SELECTOR_HEIGHT = SELECTOR_HEIGHT;
        this.BAR_HEIGHT = BAR_HEIGHT;
        this.barInsideColor = this.getAndDisposeColor(225, 225, 225);
        this.barBorderColor = this.getAndDisposeColor(211, 211, 211);
        this.barSelectionColor = this.getAndDisposeColor(41, 128, 185);
        this.selectorColor = this.getAndDisposeColor(52, 152, 219);
        this.selectorColorBorder = this.getAndDisposeColor(224, 237, 245);
        this.selectorTextColor = this.getAndDisposeColor(255, 255, 255);
        this.arrowColor = this.getAndDisposeColor(153, 203, 237);
        this.minimum = Integer.MIN_VALUE;
        this.maximum = Integer.MAX_VALUE;
        this.value = 0;
        this.xPosition = -1;
        this.textFont = this.createTextFont();
        this.addPaintListener(e -> this.paintControl(e.gc));
        this.addMouseListeners();
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return style & 0xFFFFF7FF;
        }
        return 0;
    }

    private Color getAndDisposeColor(int r, int g, int b) {
        Color color = new Color((Device)this.getDisplay(), r, g, b);
        this.addDisposeListener(e -> {
            if (!color.isDisposed()) {
                color.dispose();
            }
        });
        return color;
    }

    private Font createTextFont() {
        FontData fontData = this.getFont().getFontData()[0];
        int size = 14;
        size = this.SELECTOR_HEIGHT > 8 ? this.SELECTOR_HEIGHT / 2 - 2 : this.SELECTOR_HEIGHT / 2;
        if (size <= 4) {
            size = 4;
        }
        Font newFont = new Font((Device)this.getDisplay(), fontData.getName(), size, 1);
        this.addDisposeListener(e -> {
            if (!newFont.isDisposed()) {
                newFont.dispose();
            }
        });
        return newFont;
    }

    private void paintControl(GC gc) {
        gc.setAdvanced(true);
        gc.setAntialias(1);
        if (this.xPosition < 0) {
            this.xPosition = this.computeXPosition();
        }
        this.drawBar(gc);
        this.drawSelectionPart(gc);
        this.drawSelector(gc);
    }

    private void drawBar(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.barBorderColor);
        gc.setBackground(this.barInsideColor);
        int x = this.H_MARGIN + this.SELECTOR_WIDTH / 2;
        int y = (rect.height - this.BAR_HEIGHT) / 2;
        int width = rect.width - this.H_MARGIN * 2 - this.SELECTOR_WIDTH;
        gc.fillRoundRectangle(x, y, width, this.BAR_HEIGHT, this.BAR_HEIGHT, this.BAR_HEIGHT);
        gc.drawRoundRectangle(x, y, width, this.BAR_HEIGHT, this.BAR_HEIGHT, this.BAR_HEIGHT);
    }

    private void drawSelectionPart(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.barBorderColor);
        gc.setBackground(this.barSelectionColor);
        int x = this.H_MARGIN + this.SELECTOR_WIDTH / 2;
        int y = (rect.height - this.BAR_HEIGHT) / 2;
        gc.fillRoundRectangle(x, y, this.xPosition, this.BAR_HEIGHT, this.BAR_HEIGHT, this.BAR_HEIGHT);
        gc.drawRoundRectangle(x, y, this.xPosition, this.BAR_HEIGHT, this.BAR_HEIGHT, this.BAR_HEIGHT);
    }

    private int computeXPosition() {
        int originalWidth = this.getClientArea().width - this.H_MARGIN * 2 - this.SELECTOR_WIDTH;
        float coeff = (float)this.value * 1.0f / (float)(this.maximum - this.minimum);
        int position = (int)(coeff * (float)originalWidth);
        return position;
    }

    private void drawSelector(GC gc) {
        Rectangle rect = this.getClientArea();
        gc.setForeground(this.selectorColorBorder);
        gc.setBackground(this.selectorColor);
        int y = (rect.height - this.SELECTOR_HEIGHT) / 2;
        gc.fillRoundRectangle(this.H_MARGIN + this.xPosition, y, this.SELECTOR_WIDTH, this.SELECTOR_HEIGHT, this.SELECTOR_HEIGHT, this.SELECTOR_HEIGHT);
        gc.drawRoundRectangle(this.H_MARGIN + this.xPosition, y, this.SELECTOR_WIDTH, this.SELECTOR_HEIGHT, this.SELECTOR_HEIGHT, this.SELECTOR_HEIGHT);
        gc.setForeground(this.arrowColor);
        gc.setLineWidth(3);
        int baseY = y + this.SELECTOR_HEIGHT / 2;
        gc.drawLine(this.H_MARGIN + this.xPosition + 10, baseY, this.H_MARGIN + this.xPosition + 17, baseY - 7);
        gc.drawLine(this.H_MARGIN + this.xPosition + 10, baseY, this.H_MARGIN + this.xPosition + 17, baseY + 7);
        gc.drawLine(this.H_MARGIN + this.xPosition + this.SELECTOR_WIDTH - 10, baseY, this.H_MARGIN + this.xPosition + this.SELECTOR_WIDTH - 17, baseY - 7);
        gc.drawLine(this.H_MARGIN + this.xPosition + this.SELECTOR_WIDTH - 10, baseY, this.H_MARGIN + this.xPosition + this.SELECTOR_WIDTH - 17, baseY + 7);
        gc.setForeground(this.selectorTextColor);
        gc.setFont(this.textFont);
        String valueAsString = String.valueOf(this.value);
        Point textSize = gc.textExtent(valueAsString);
        int xText = this.H_MARGIN + this.xPosition + this.SELECTOR_WIDTH / 2;
        gc.drawText(valueAsString, xText - textSize.x / 2, y + 2, true);
    }

    private void addMouseListeners() {
        this.addListener(3, e -> {
            int y = (this.getClientArea().height - this.SELECTOR_HEIGHT) / 2;
            Rectangle rect = new Rectangle(this.xPosition + this.H_MARGIN, y, this.SELECTOR_WIDTH, this.SELECTOR_HEIGHT);
            if (!rect.contains(e.x, e.y)) {
                return;
            }
            this.moving = true;
            this.mouseDeltaX = this.xPosition - e.x;
        });
        this.addListener(4, e -> {
            this.moving = false;
            this.mouseDeltaX = 0;
            this.redraw();
        });
        this.addListener(5, e -> {
            int originalWidth;
            if (!this.moving) {
                return;
            }
            this.xPosition = e.x + this.mouseDeltaX;
            if (this.xPosition < 0) {
                this.xPosition = 0;
            }
            if (this.xPosition > (originalWidth = this.getClientArea().width - this.H_MARGIN * 2 - this.SELECTOR_WIDTH)) {
                this.xPosition = originalWidth;
            }
            float ratio = (float)this.xPosition / (float)originalWidth;
            this.value = this.minimum + (int)Math.floor(ratio * (float)(this.maximum - this.minimum));
            if (this.value < this.minimum) {
                this.value = this.minimum;
            } else if (this.value > this.maximum) {
                this.value = this.maximum;
            }
            SelectionListenerUtil.fireSelectionListeners((Control)this, e);
            this.redraw();
        });
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.addSelectionListener((Control)this, listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(wHint, hHint, changed);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.removeSelectionListener((Control)this, listener);
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.checkWidget();
        if (minimum > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is greater than the maximum value (%d)", minimum, this.maximum)));
        }
        this.minimum = minimum;
        this.redraw();
        this.update();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.checkWidget();
        if (maximum < this.minimum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is lower than the minimum value (%d)", maximum, this.minimum)));
        }
        this.maximum = maximum;
        this.redraw();
        this.update();
    }

    public int getValue() {
        this.checkWidget();
        return this.value;
    }

    public void setValue(int value) {
        this.checkWidget();
        if (value < this.minimum || value > this.maximum) {
            SWT.error((int)5, (Throwable)new IllegalArgumentException(String.format("Value %d is not int the range [%d - %d]", value, this.minimum, this.maximum)));
        }
        this.value = value;
        this.xPosition = -1;
        this.redraw();
        this.update();
    }
}

