/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * Created on 6.10.2005
 * @author Toni Kalajainen 
 */
package org.simantics.utils.ui.validators;

import java.text.DateFormat;
import java.text.ParseException;

import org.eclipse.jface.dialogs.IInputValidator;

public class DateValidator implements IInputValidator {

    private final DateFormat format;
    
    public DateValidator(DateFormat format) {
        this.format = format;
    }

    public String isValid(String newText) {
        try {
            format.parse(newText);
            return null;
        } catch (ParseException e) {
            return e.getMessage();
        }        
    }
        
}
