/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.jface;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubContributionManager;

/**
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class MenuTools {

	/**
	 * Searches for existing menu, or creates a new menu.
	 * @param uniqueID unique id of the contributor (editor's ID + input)
	 * @param name name of the menu
	 * @param manager
	 * @return the menu (created or existing)
	 */
	public static IMenuManager getOrCreate(String uniqueID,String name, IMenuManager manager) {
    	IContributionItem menu = manager.find(uniqueID+name);
    	if (menu == null) {
			 MenuManager m = new MenuManager(name,uniqueID+name);
			 manager.add(m);
			 m.setVisible(true);
			 return m;
		 }
    	if (menu instanceof SubContributionManager) {
    		// without this recreated menus would show only the first item.
    		SubContributionManager emenu = (SubContributionManager)menu;
    		return (IMenuManager)emenu.getParent();
    	}
    	return (IMenuManager)menu;
    }
}
