/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 10.10.2006
 */
package org.simantics.utils.ui.gfx;

import java.util.Objects;


/**
 * Dimensions
 * @author Toni Kalajainen
 */
public final class Dimensions {

    public final static Double INCH = 25.4;
    
    /** Pixel size, may be null if unknown */
    public final PixelDimension pixelDimension;
    
    /** Physical size, may be null if unknown */
    public final PhysicalDimension physicaldimension;
    
    public Dimensions(PixelDimension pixelDimension, PhysicalDimension physicalDimension)
    {
        this.physicaldimension = physicalDimension;
        this.pixelDimension = pixelDimension;
    }
    
    @Override
    public int hashCode() {
        int code = 0;
        if (pixelDimension!=null) code^= pixelDimension.hashCode();
        if (physicaldimension!=null) code^= physicaldimension.hashCode();
        return code;
    }
    
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Dimensions)) return false;
        Dimensions other = (Dimensions) obj;
        return Objects.equals(other.physicaldimension, physicaldimension) &&
               Objects.equals(other.pixelDimension, pixelDimension);
    }
    
    
    
    public PhysicalDimension getPhysicaldimension() {
        return physicaldimension;
    }

    public PixelDimension getPixelDimension() {
        return pixelDimension;
    }

    /**
     * Calculate horizontal Dots per inch.
     * @return horizontal DPI or null if value is not available
     */
    public Double getHorizontalDPI()
    {
        if (pixelDimension==null || physicaldimension==null) return null;
        if (physicaldimension.width==0) return null;
        return (((double) pixelDimension.width)/physicaldimension.width)*INCH;
    }
    
    /**
     * Calculate vertical Dots per inch.
     * @return Vertical DPI or null if value is not available
     */
    public Double getVerticalDPI()    
    {
        if (pixelDimension==null || physicaldimension==null) return null;
        if (physicaldimension.height==0) return null;
        return (((double) pixelDimension.height)/physicaldimension.height)*INCH;
    }
    
    @Override
    public String toString() {
        return "Dimensions [" + physicaldimension + ", " + pixelDimension + "]";
    }
    
    /**
     * returns aspect ratio (width / height)
     * @return returns aspect ratio (width / height)
     */
    public double getAspectRatio()
    {
        if (physicaldimension!=null)
            return physicaldimension.getAspectRatio();
        if (pixelDimension!=null)
            return pixelDimension.getAspectRatio();
        return 1;
    }
    
    
}
