/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.color;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;



/**
 * 
 * @author Marko Luukkainen
 *
 */
public class ColorIconCreator {

	/**
	 * Creates square image with defined color<br>
	 * Images created this way must be disposed<br>
	 * @param color
	 * @param size
	 * @return
	 */
	public static Image createImage(Color color, int size, int style) {
		return createImage(color,size,size,style);
	}
	/**
	 * Creates rectangle image with defined color<br>
	 * Images created this way must be disposed<br>
	 * @param color
	 * @param width
	 * @param height
	 * @return
	 */
	public static Image createImage(Color color, int width, int height, int style) {
		Display display = Display.getCurrent();
        Image image = new Image(display, width, height);
        GC gc = new GC(image);
        org.eclipse.swt.graphics.Color swtColor = new org.eclipse.swt.graphics.Color(display, color.getR(), color.getG(), color.getB());
        gc.setBackground(swtColor);
        gc.setForeground(swtColor);
        gc.fillRectangle(0, 0, width, height);
        if ((style & SWT.BORDER) > 0) {
        	gc.setForeground(display.getSystemColor(SWT.COLOR_BLACK));
        	gc.drawRectangle(0, 0, width-1, height-1);
        }
        swtColor.dispose();
        gc.dispose();
		return image;
	}
	
}
