/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.ui.color;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

/**
 * 
 * Canvas that shows color gradients
 * 
 * @author Marko Luukkainen
 *
 */
public class ColorGradientCanvas extends Canvas{
	ColorGradient gradient;
	int style;
	
	public ColorGradientCanvas(Composite parent, int style) {
		super(parent,(style|SWT.BORDER)&(~(SWT.VERTICAL|SWT.HORIZONTAL))|SWT.DOUBLE_BUFFERED);
		this.style = style & (SWT.VERTICAL | SWT.HORIZONTAL) ;
		addPaintListener(createPaintListener());
	}
	
	public void setGradient(ColorGradient gradient) {
		this.gradient = gradient;
		this.redraw();
	}	
	
	protected PaintListener createPaintListener() {
		return new PaintListener() {
			public void paintControl(PaintEvent e) {
				GC gc = e.gc;
				Rectangle size = ColorGradientCanvas.this.getClientArea();
				paintGradient(gc, size);
			}
		};
	}
	
	protected void paintGradient(GC gc, Rectangle clip) {
		if (gradient != null) {
			Image image = gradient.getGradientImage(clip.width,clip.height,ColorGradientCanvas.this.style);
			gc.drawImage(image, 0, 0);
			image.dispose();		
		} else {
			gc.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_WHITE));
			gc.fillRectangle(clip);
		}
	}

}
