/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.threads;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import org.simantics.utils.threads.AWTExecutorSync;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.CurrentThread;
import org.simantics.utils.threads.CurrentThreadExecutor;
import org.simantics.utils.threads.Executable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger LOGGER;
    public static final int CORES;
    private static final String PROP_EXECUTOR_NON_BLOCKING_CORE_POOL_SIZE = "simantics.executor.nonBlocking.corePoolSize";
    private static final String PROP_EXECUTOR_BLOCKING_CORE_POOL_SIZE = "simantics.executor.blocking.corePoolSize";
    private static final String PROP_EXECUTOR_BLOCKING_MAX_THREADS = "simantics.executor.blockingMaxThreads";
    public static final int NON_BLOCKING_EXECUTOR_CORE_POOL_SIZE;
    public static final int BLOCKING_EXECUTOR_CORE_POOL_SIZE;
    public static ScheduledExecutorService NON_BLOCKING_EXECUTOR;
    public static ExecutorService BLOCKING_EXECUTOR;
    static ScheduledExecutorService TIMER;
    static Map<Thread, WaitingThread> map;
    private static Map<Thread, Thread[]> DEPENDENCIES;
    public static Executor CURRENT_THREAD;
    public static ExecutorService AWT_EDT;
    public static ExecutorService AWT_EDT_SYNC;

    static {
        int blockingMaxThreads;
        LOGGER = LoggerFactory.getLogger(ThreadUtils.class);
        CORES = Runtime.getRuntime().availableProcessors();
        NON_BLOCKING_EXECUTOR_CORE_POOL_SIZE = ThreadUtils.parseCoreBasedIntProp(PROP_EXECUTOR_NON_BLOCKING_CORE_POOL_SIZE, CORES, 8);
        int blockingExecutorCorePoolSize = ThreadUtils.parseCoreBasedIntProp(PROP_EXECUTOR_BLOCKING_CORE_POOL_SIZE, CORES, 8);
        int specifiedBlockingCorePoolSize = ThreadUtils.parseInt(System.getProperty(PROP_EXECUTOR_BLOCKING_CORE_POOL_SIZE), -1);
        if (specifiedBlockingCorePoolSize != blockingExecutorCorePoolSize && (blockingMaxThreads = ThreadUtils.parseInt(System.getProperty(PROP_EXECUTOR_BLOCKING_MAX_THREADS), -1)) > 0) {
            blockingExecutorCorePoolSize = Math.max(Math.max(blockingMaxThreads, 8), CORES);
        }
        BLOCKING_EXECUTOR_CORE_POOL_SIZE = blockingExecutorCorePoolSize;
        map = new HashMap<Thread, WaitingThread>();
        DEPENDENCIES = Collections.synchronizedMap(new HashMap());
        CURRENT_THREAD = new CurrentThreadExecutor();
        AWT_EDT = AWTThread.INSTANCE;
        AWT_EDT_SYNC = new AWTExecutorSync();
    }

    private static final int parseInt(String s, int defaultValue) {
        try {
            return s != null ? Integer.parseInt(s) : defaultValue;
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private static final int parseCoreBasedIntProp(String prop, int min, int max) {
        int n = Math.min(Math.max(min, CORES), max);
        return ThreadUtils.parseInt(System.getProperty(prop), n);
    }

    public static CurrentThread getCurrentThread() {
        return CurrentThread.INSTANCE;
    }

    public static synchronized ScheduledExecutorService getTimer() {
        if (TIMER == null) {
            final ThreadGroup tg = new ThreadGroup("Timer");
            final AtomicInteger counter = new AtomicInteger(0);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(tg, r, "Timer-" + counter.incrementAndGet());
                    if (!t.isDaemon()) {
                        t.setDaemon(true);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            TIMER = new ScheduledThreadPoolExecutor(1, tf);
        }
        return TIMER;
    }

    public static synchronized ScheduledExecutorService getNonBlockingWorkExecutor() {
        if (NON_BLOCKING_EXECUTOR == null) {
            final ThreadGroup tg = new ThreadGroup("Non-Blocking-Worker-Group");
            final AtomicInteger counter = new AtomicInteger(0);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(tg, r, "Non-Blocking-Worker-" + counter.incrementAndGet());
                    if (!t.isDaemon()) {
                        t.setDaemon(true);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            NON_BLOCKING_EXECUTOR = new ScheduledThreadPoolExecutor(NON_BLOCKING_EXECUTOR_CORE_POOL_SIZE, tf);
        }
        return NON_BLOCKING_EXECUTOR;
    }

    public static synchronized ExecutorService getBlockingWorkExecutor() {
        if (BLOCKING_EXECUTOR == null) {
            final ThreadGroup tg = new ThreadGroup("Blocking-Worker-Group");
            final AtomicInteger counter = new AtomicInteger(0);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(tg, r, "Blocking-Worker-" + counter.incrementAndGet());
                    if (!t.isDaemon()) {
                        t.setDaemon(true);
                    }
                    if (t.getPriority() != 5) {
                        t.setPriority(5);
                    }
                    return t;
                }
            };
            BLOCKING_EXECUTOR = new ScheduledThreadPoolExecutor(BLOCKING_EXECUTOR_CORE_POOL_SIZE, tf);
        }
        return BLOCKING_EXECUTOR;
    }

    public static IThreadWorkQueue getBetterThreadAccess(IThreadWorkQueue access) {
        if (access instanceof BetterThreadAccess) {
            return access;
        }
        return new BetterThreadAccess(access);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean syncExec(IThreadWorkQueue threadAccess, Runnable runnable) {
        if (threadAccess instanceof BetterThreadAccess) {
            threadAccess = ((BetterThreadAccess)threadAccess).ta;
        }
        if (threadAccess.currentThreadAccess()) {
            try {
                runnable.run();
                return true;
            }
            catch (RuntimeException e) {
                ThreadUtils.handleRunnableError(e);
            }
            return true;
        }
        Thread senderThread = Thread.currentThread();
        final WaitingThread wt = new WaitingThread(senderThread);
        Event e = new Event(runnable, new EventListener(){

            @Override
            public void eventDone(Event e) {
                wt.completed(e);
            }
        }, null);
        Class<ThreadUtils> clazz = ThreadUtils.class;
        synchronized (ThreadUtils.class) {
            WaitingThread waitingThread;
            WaitingThread targetWt = ThreadUtils.getWaitingThread(threadAccess.getThread());
            Thread waitingForThread = null;
            if (targetWt != null && ThreadUtils.isEventQueuingAllowed(senderThread, targetWt) && targetWt.addEvent(e)) {
                waitingThread = wt;
                synchronized (waitingThread) {
                    waitingForThread = targetWt.thread;
                    e.setThread(waitingForThread);
                    wt.waitFor(e);
                }
            }
            if (waitingForThread == null) {
                waitingThread = wt;
                synchronized (waitingThread) {
                    waitingForThread = threadAccess.asyncExec(e);
                    if (waitingForThread == null) {
                        // MONITOREXIT @DISABLED, blocks:[1, 3, 4, 5, 11, 12] lbl36 : MonitorExitStatement: MONITOREXIT : var9_9
                        // ** MonitorExit[var6_6] (shouldn't be in output)
                        return false;
                    }
                    e.setThread(waitingForThread);
                    wt.waitFor(e);
                }
            }
            WaitingThread prevWt = ThreadUtils.setWaitingThread(senderThread, wt);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            wt.waitAndProcessEvents();
            wt.stopAcceptingEvents();
            ThreadUtils.removeWaitingThread(senderThread, prevWt);
            wt.waitAndProcessEvents();
            return true;
        }
    }

    public static boolean multiSyncExec(Collection<Executable> executions) {
        if (executions.isEmpty()) {
            return true;
        }
        return ThreadUtils.multiSyncExec(executions.toArray(new Executable[executions.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean multiSyncExec(Executable ... executions) {
        if (executions.length == 0) {
            return true;
        }
        if (executions.length == 1) {
            return ThreadUtils.syncExec(executions[0].threadAccess, executions[0].runnable);
        }
        Thread senderThread = Thread.currentThread();
        final WaitingThread wt = new WaitingThread(senderThread);
        WaitingThread prevWt = null;
        Class<ThreadUtils> clazz = ThreadUtils.class;
        synchronized (ThreadUtils.class) {
            Executable[] executableArray = executions;
            int n = executions.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    prevWt = ThreadUtils.setWaitingThread(senderThread, wt);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    break;
                }
                Executable pair = executableArray[n2];
                IThreadWorkQueue threadAccess = pair.threadAccess;
                if (!threadAccess.currentThreadAccess()) {
                    WaitingThread waitingThread;
                    if (threadAccess instanceof BetterThreadAccess) {
                        threadAccess = ((BetterThreadAccess)threadAccess).ta;
                    }
                    Runnable runnable = pair.runnable;
                    Event e = new Event(runnable, new EventListener(){

                        @Override
                        public void eventDone(Event e) {
                            wt.completed(e);
                        }
                    }, null);
                    WaitingThread targetWt = ThreadUtils.getWaitingThread(threadAccess.getThread());
                    Thread waitingForThread = null;
                    if (targetWt != null && ThreadUtils.isEventQueuingAllowed(senderThread, targetWt) && targetWt.addEvent(e)) {
                        waitingThread = wt;
                        synchronized (waitingThread) {
                            waitingForThread = targetWt.thread;
                            e.setThread(waitingForThread);
                            wt.waitFor(e);
                        }
                    }
                    if (waitingForThread == null) {
                        waitingThread = wt;
                        synchronized (waitingThread) {
                            waitingForThread = threadAccess.asyncExec(e);
                            if (waitingForThread == null) {
                                // MONITOREXIT @DISABLED, blocks:[0, 2, 20, 4, 5, 11, 14, 15] lbl46 : MonitorExitStatement: MONITOREXIT : var14_17
                                // ** MonitorExit[var4_4] (shouldn't be in output)
                                return false;
                            }
                            e.setThread(waitingForThread);
                            wt.waitFor(e);
                        }
                    }
                }
                ++n2;
            }
            Executable[] executableArray2 = executions;
            n2 = executions.length;
            int n3 = 0;
            while (n3 < n2) {
                Executable pair = executableArray2[n3];
                IThreadWorkQueue threadAccess = pair.threadAccess;
                Runnable runnable = pair.runnable;
                if (threadAccess.currentThreadAccess()) {
                    try {
                        runnable.run();
                    }
                    catch (RuntimeException e) {
                        ThreadUtils.handleRunnableError(e);
                    }
                }
                ++n3;
            }
            wt.waitAndProcessEvents();
            wt.stopAcceptingEvents();
            ThreadUtils.removeWaitingThread(senderThread, prevWt);
            wt.waitAndProcessEvents();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thread asyncExec(IThreadWorkQueue threadAccess, Runnable runnable) {
        if (threadAccess instanceof BetterThreadAccess) {
            threadAccess = ((BetterThreadAccess)threadAccess).ta;
        }
        Thread senderThread = Thread.currentThread();
        Class<ThreadUtils> clazz = ThreadUtils.class;
        synchronized (ThreadUtils.class) {
            Event e = new Event(runnable, null, null);
            WaitingThread targetWt = ThreadUtils.getWaitingThread(threadAccess.getThread());
            if (targetWt != null && ThreadUtils.isEventQueuingAllowed(senderThread, targetWt) && targetWt.addEvent(e)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return targetWt.thread;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return threadAccess.asyncExec(runnable);
        }
    }

    private static boolean _waitsFor(Thread sourceThread, Thread targetThread, Set<Thread> visitedTargetThreads) {
        assert (targetThread != null);
        if (visitedTargetThreads.contains(targetThread)) {
            return false;
        }
        visitedTargetThreads.add(targetThread);
        if (sourceThread == targetThread) {
            return false;
        }
        Set<Thread> waitsFor = ThreadUtils.getWaitsForThreads(targetThread);
        if (waitsFor == null || waitsFor.isEmpty()) {
            return false;
        }
        for (Thread aThreadTargetThreadWaitsFor : waitsFor) {
            if (aThreadTargetThreadWaitsFor == sourceThread) {
                return true;
            }
            if (visitedTargetThreads.contains(aThreadTargetThreadWaitsFor) || !ThreadUtils._waitsFor(sourceThread, aThreadTargetThreadWaitsFor, visitedTargetThreads)) continue;
            return true;
        }
        return false;
    }

    static boolean waitsFor(Thread sourceThread, Thread targetThread) {
        return ThreadUtils._waitsFor(sourceThread, targetThread, new HashSet<Thread>(3));
    }

    static boolean isEventQueuingAllowed(Thread sourceThread, WaitingThread eventQueue) {
        if (!eventQueue.acceptEvents) {
            return false;
        }
        return ThreadUtils.waitsFor(sourceThread, eventQueue.thread);
    }

    private static void handleRunnableError(Throwable t) {
        t.printStackTrace();
    }

    static synchronized WaitingThread getWaitingThreadSync(Thread t) {
        WaitingThread result;
        while ((result = map.get(t)) == null) {
            try {
                ThreadUtils.class.wait();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        return result;
    }

    static Set<Thread> getWaitsForThreads(Thread t) {
        WaitingThread wt = ThreadUtils.getWaitingThread(t);
        if (wt == null) {
            return null;
        }
        return wt.getWaitingForThreads();
    }

    static synchronized WaitingThread getWaitingThread(Thread t) {
        return map.get(t);
    }

    static synchronized WaitingThread setWaitingThread(Thread t, WaitingThread wt) {
        WaitingThread prev = map.put(t, wt);
        ThreadUtils.class.notifyAll();
        return prev;
    }

    static synchronized void removeWaitingThread(Thread t, WaitingThread replaceWith) {
        assert (t == Thread.currentThread());
        map.remove(t);
        if (replaceWith != null) {
            map.put(t, replaceWith);
        }
    }

    public static void exec(Executor executor, final Runnable command) {
        final Thread[] calleeThread = new Thread[1];
        Thread callerThread = Thread.currentThread();
        Runnable wrappedCommand = new Runnable(){

            @Override
            public void run() {
                calleeThread[0] = Thread.currentThread();
                command.run();
            }
        };
        DEPENDENCIES.put(callerThread, calleeThread);
        executor.execute(wrappedCommand);
        DEPENDENCIES.remove(callerThread);
    }

    private static boolean hasDependency(Thread waiter, Thread worker) {
        Thread t = waiter;
        while (t != null) {
            Thread[] potentialResult = DEPENDENCIES.get(t);
            if (potentialResult == null) break;
            t = potentialResult[0];
            if (t != worker) continue;
            return true;
        }
        return false;
    }

    public static void lock(Lock ... locks) {
        if (locks.length == 0) {
            return;
        }
        if (locks.length == 1) {
            locks[0].lock();
            return;
        }
        while (true) {
            int i = 0;
            while (i < locks.length) {
                Lock l = locks[i];
                if (l != null && !locks[i].tryLock()) break;
                ++i;
            }
            if (i == locks.length) {
                return;
            }
            int j = 0;
            while (j < i) {
                Lock l = locks[j];
                if (l != null) {
                    l.unlock();
                }
                ++j;
            }
            try {
                TimeUnit.NANOSECONDS.sleep(10000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static void lock2(Lock[] locks1, Lock[] locks2) {
        int l1 = locks1.length;
        int l2 = locks2.length;
        int c = l1 + l2;
        if (l1 == 0 && l2 == 0) {
            return;
        }
        while (true) {
            Lock l;
            Lock l3;
            int i = 0;
            while (i < l1) {
                l3 = locks1[i];
                if (l3 != null && !locks1[i].tryLock()) break;
                ++i;
            }
            if (i == l1) {
                while (i < c) {
                    l3 = locks2[i];
                    if (l3 != null && !locks2[i - l1].tryLock()) break;
                    ++i;
                }
            }
            if (i == c) {
                return;
            }
            if (i > l1) {
                int j = l1;
                while (j < i) {
                    l = locks2[j - l1];
                    if (l != null) {
                        l.unlock();
                    }
                    ++j;
                }
            }
            if (i > 0) {
                int j = 0;
                while (j < i) {
                    l = locks1[j];
                    if (l != null) {
                        l.unlock();
                    }
                    ++j;
                }
            }
            try {
                TimeUnit.NANOSECONDS.sleep(1L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public static boolean tryLock(Lock ... locks) {
        if (locks.length == 0) {
            return true;
        }
        if (locks.length == 1) {
            return locks[0].tryLock();
        }
        int i = 0;
        while (i < locks.length) {
            Lock l = locks[i];
            if (l != null && !locks[i].tryLock()) break;
            ++i;
        }
        if (i == locks.length) {
            return true;
        }
        int j = 0;
        while (j < i) {
            Lock l = locks[j];
            if (l != null) {
                l.unlock();
            }
            ++j;
        }
        return false;
    }

    public static void unlock(Lock ... locks) {
        Lock[] lockArray = locks;
        int n = locks.length;
        int n2 = 0;
        while (n2 < n) {
            Lock lock = lockArray[n2];
            if (lock != null) {
                lock.unlock();
            }
            ++n2;
        }
    }

    public static void unlock2(Lock[] locks1, Lock[] locks2) {
        Lock lock;
        Lock[] lockArray = locks1;
        int n = locks1.length;
        int n2 = 0;
        while (n2 < n) {
            lock = lockArray[n2];
            if (lock != null) {
                lock.unlock();
            }
            ++n2;
        }
        lockArray = locks2;
        n = locks2.length;
        n2 = 0;
        while (n2 < n) {
            lock = lockArray[n2];
            if (lock != null) {
                lock.unlock();
            }
            ++n2;
        }
    }

    public static Lock[] appendLockArrays(Lock[] ... lockArrays) {
        int len = 0;
        Lock[][] lockArray = lockArrays;
        int n = lockArrays.length;
        int n2 = 0;
        while (n2 < n) {
            Lock[] array = lockArray[n2];
            len += array.length;
            ++n2;
        }
        Lock[] result = new Lock[len];
        int i = 0;
        Lock[][] lockArray2 = lockArrays;
        int n3 = lockArrays.length;
        int n4 = 0;
        while (n4 < n3) {
            Lock[] array = lockArray2[n4];
            System.arraycopy(array, 0, result, i, array.length);
            i += array.length;
            ++n4;
        }
        return result;
    }

    public static synchronized void shutdown() {
        if (TIMER != null) {
            ThreadUtils.shutdownAndAwaitTermination(TIMER, 1000L);
            TIMER = null;
        }
        if (NON_BLOCKING_EXECUTOR != null) {
            ThreadUtils.shutdownAndAwaitTermination(NON_BLOCKING_EXECUTOR, 1000L);
            NON_BLOCKING_EXECUTOR = null;
        }
        if (BLOCKING_EXECUTOR != null) {
            ThreadUtils.shutdownAndAwaitTermination(BLOCKING_EXECUTOR, 1000L);
            BLOCKING_EXECUTOR = null;
        }
    }

    static void shutdownAndAwaitTermination(ExecutorService pool, long timeoutMs) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                List<Runnable> leftovers = pool.shutdownNow();
                if (!leftovers.isEmpty()) {
                    LOGGER.warn("Thread pool '" + pool.toString() + "' contained " + leftovers.size() + " tasks at forced shutdown: " + leftovers);
                }
                if (!pool.awaitTermination(timeoutMs, TimeUnit.MILLISECONDS)) {
                    LOGGER.warn("Thread pool '" + pool.toString() + "' did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static void uncheckedAwaitTermination(ExecutorService service, long time) {
        try {
            NON_BLOCKING_EXECUTOR.awaitTermination(time, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    static class BetterThreadAccess
    implements IThreadWorkQueue {
        IThreadWorkQueue ta;

        public BetterThreadAccess(IThreadWorkQueue ta) {
            if (ta instanceof BetterThreadAccess) {
                ta = ((BetterThreadAccess)ta).ta;
            }
            this.ta = ta;
        }

        @Override
        public Thread asyncExec(Runnable runnable) {
            return ThreadUtils.asyncExec(this.ta, runnable);
        }

        @Override
        public boolean currentThreadAccess() {
            return this.ta.currentThreadAccess();
        }

        @Override
        public Thread getThread() {
            return this.ta.getThread();
        }

        @Override
        public boolean syncExec(Runnable runnable) {
            return ThreadUtils.syncExec(this.ta, runnable);
        }
    }

    public static class Event
    implements Runnable {
        Runnable r;
        EventListener l;
        Semaphore s;
        Thread t;

        public Event(Runnable r, EventListener l, Semaphore s) {
            this.r = r;
            this.l = l;
            this.s = s;
        }

        @Override
        public void run() {
            this.setThread(Thread.currentThread());
            try {
                try {
                    this.r.run();
                }
                catch (RuntimeException e) {
                    ThreadUtils.handleRunnableError(e);
                    if (this.s != null) {
                        this.s.release(1);
                    }
                    if (this.l != null) {
                        this.l.eventDone(this);
                    }
                }
            }
            finally {
                if (this.s != null) {
                    this.s.release(1);
                }
                if (this.l != null) {
                    this.l.eventDone(this);
                }
            }
        }

        public synchronized Thread getThread() {
            while (this.t == null) {
                try {
                    this.t.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.t;
        }

        public synchronized void setThread(Thread t) {
            assert (t != null);
            if (this.t != null) assert (this.t == t);
            this.t = t;
            this.notify();
        }
    }

    static interface EventListener {
        public void eventDone(Event var1);
    }

    static class WaitingThread {
        final Thread thread;
        LinkedList<Event> queue = new LinkedList();
        boolean acceptEvents = true;
        Set<Event> waitingFor = new HashSet<Event>();
        Set<Event> completed = new HashSet<Event>();
        private static int WAIT_MS = 10000;
        private static int WAIT_THRESHOLD_NS = 900000 * WAIT_MS;

        public WaitingThread(Thread thread) {
            this.thread = thread;
        }

        public synchronized void waitFor(Event event) {
            assert (this.thread != null);
            this.waitingFor.add(event);
        }

        public synchronized void completed(Event event) {
            this.completed.add(event);
            if (this.completed.size() == this.waitingFor.size()) {
                this.notify();
            }
        }

        synchronized boolean isEmpty() {
            return this.queue.isEmpty();
        }

        synchronized boolean keepWaiting() {
            if (this.waitingFor.size() != this.completed.size()) {
                return true;
            }
            assert (this.waitingFor.equals(this.completed));
            return false;
        }

        public synchronized boolean addEvent(Event r) {
            if (!this.acceptEvents) {
                return false;
            }
            this.queue.add(r);
            this.notify();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitAndProcessEvents() {
            Event e;
            while (this.keepWaiting() || !this.isEmpty()) {
                e = null;
                WaitingThread waitingThread = this;
                synchronized (waitingThread) {
                    if (!this.queue.isEmpty()) {
                        e = this.queue.pop();
                    }
                    if (e == null && this.keepWaiting()) {
                        try {
                            long now = System.nanoTime();
                            this.wait(WAIT_MS);
                            long duration = System.nanoTime() - now;
                            if (duration > (long)WAIT_THRESHOLD_NS) {
                                for (Thread t : this.getWaitingForThreads()) {
                                    if (t.isAlive()) continue;
                                    throw new IllegalStateException("Thread '" + this.thread + "' has died.");
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (e == null) continue;
                try {
                    e.run();
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }
            while (!this.isEmpty()) {
                e = null;
                WaitingThread e1 = this;
                synchronized (e1) {
                    if (!this.queue.isEmpty()) {
                        e = this.queue.pop();
                    }
                }
                if (e == null) continue;
                try {
                    e.run();
                }
                catch (RuntimeException e2) {
                    e2.printStackTrace();
                }
            }
        }

        public synchronized void stopAcceptingEvents() {
            this.acceptEvents = false;
        }

        public synchronized Set<Thread> getWaitingForThreads() {
            HashSet<Thread> result = new HashSet<Thread>(this.waitingFor.size());
            for (Event e : this.waitingFor) {
                if (this.completed.contains(e)) continue;
                result.add(e.getThread());
            }
            return result;
        }
    }
}

