/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/

package org.simantics.utils.threads.ua;

/**
 * Listener for state changes
 * 
 * @author Toni Kalajainen (toni.kalajainen@vtt.fi)
 */
public interface StateListener<StateType> {

	/**
	 * Call-back for state transition
	 * 
	 * @param sender State monitor object
	 * @param oldState new state
	 * @param newState new state
	 */
	void onStateTransition(IStatefulObject<StateType, ?> sender, StateType oldState, StateType newState);
	
}
