package org.simantics.utils.commandlog;

import org.simantics.utils.commandlog.internal.CommandRecorderTracker;

/**
 * A utility class only with static methods for recording commands.
 */
public class Commands {
	private Commands() {
	}
	
	/**
	 * Checks whether command recording is currently active. UI code recording
	 * commands can use this method to skip some unnecessary work needed for
	 * command recording.
	 */
	public static boolean isRecording() {
		return CommandRecorderTracker.TRACKER != null && 
				CommandRecorderTracker.TRACKER.isRecording();
	}

	/**
	 * Records a command. If command recording is not active, this does nothing.
	 */
	public static void record(Command command) {
		CommandRecorderTracker tracker = CommandRecorderTracker.TRACKER;
		if (tracker != null)
			for (CommandRecorder handler : tracker.commandHandlers)
				if (handler.isRecording()) 
					handler.handleCommand(command);
	}
	
	/**
	 * Records a command. If command recording is not active, this does nothing.
	 */
	public static void record(Object graph, Command command) {
		CommandRecorderTracker tracker = CommandRecorderTracker.TRACKER;
		if (tracker != null)
			for (CommandRecorder handler : tracker.commandHandlers)
				handler.handleCommand(graph, command);
	}	
}
