package org.simantics.utils.commandlog;

/**
 * <p>
 * Marker interface for commands to be recorded.
 * 
 * <p>
 * Use {@link Commands} for posting commands and {@link CommandRecorder} to
 * listen them.
 */
public interface Command {
	
	/**
	 * If command recording is enabled, this method should be called
	 * to wait that all data becomes available for the command object.
	 */
	default void waitCompleted() throws Exception {
	}
}
