/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils;

import java.util.Random;

/**
 * UniqueID attempts to creates unique IDs. 
 * @author Toni Kalajainen
 * @deprecated should be removed in my opinion [Tuukka], no real use.
 */
public class UniqueID {
    
    public static final String RESTORE_PREFIX = "restore-";
    
    protected final static Random RANDOM = new Random(System.currentTimeMillis());
    protected static long COUNTER = RANDOM.nextLong();
    
    public static String _createUniqueID() {
        synchronized(UniqueID.class) {
            Long value = COUNTER++;
            Long random = RANDOM.nextLong();
            return Long.toHexString(value).toUpperCase() + 
                   Long.toHexString(random);
        }
    }    

    public static String createViewSiteSecondaryID(boolean restore) {
        if (!restore)
            return _createUniqueID();
        return RESTORE_PREFIX+_createUniqueID();
    }
       
    
}
