/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures.slice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.utils.datastructures.slice.Sliceable;
import org.simantics.utils.datastructures.slice.ValueRange;

public final class SliceUtil {
    public static final int MAX_NODES_PER_LEVEL_EXP = 2;

    public static <T extends Sliceable<T>> Collection<T> subnodify(Sliceable<T> prop) {
        return SliceUtil.subnodify(prop, prop.getRange());
    }

    public static <T extends Sliceable<T>> Collection<T> subnodify(Sliceable<T> prop, ValueRange range) {
        return SliceUtil.subnodify(prop, range.start(), range.size(), 2);
    }

    public static <T extends Sliceable<T>> Collection<T> subnodify(Sliceable<T> prop, int rangeStart, int rangeSize) {
        return SliceUtil.subnodify(prop, rangeStart, rangeSize, 2);
    }

    public static <T> Collection<T> subnodify(Object p, int rangeStart, int rangeSize, int pow10OfItemsPerLevel) {
        if (rangeSize < 2) {
            return Collections.emptyList();
        }
        if (!(p instanceof Sliceable)) {
            return Collections.emptyList();
        }
        Sliceable prop = (Sliceable)p;
        int nodes = rangeSize;
        int intervalSize = 1;
        int maxNodesPerLevel = (int)Math.pow(10.0, pow10OfItemsPerLevel);
        if (rangeSize > maxNodesPerLevel) {
            double intervalSizeExp = Math.floor(Math.log10(rangeSize));
            double intervalMaxSize = Math.pow(10.0, intervalSizeExp);
            if ((int)intervalMaxSize == rangeSize) {
                intervalMaxSize = Math.pow(10.0, Math.max(intervalSizeExp - (double)pow10OfItemsPerLevel, (double)pow10OfItemsPerLevel));
            }
            nodes = (int)Math.ceil((double)rangeSize / intervalMaxSize);
            intervalSize = (int)intervalMaxSize;
        }
        int start = rangeStart;
        int sizeLeft = rangeSize;
        ArrayList result = new ArrayList(nodes);
        int i = 0;
        while (i < nodes) {
            result.add(prop.slice(ValueRange.make(start, Math.min(intervalSize, sizeLeft))));
            start += intervalSize;
            sizeLeft -= intervalSize;
            ++i;
        }
        return result;
    }
}

