/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures.hints;

import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * A hint listener that reports all changes to the listened hint through
 * hintChanged instead of hintChanged+hintRemoved. When the hint is removed,
 * a null newValue will be given.
 *
 * <p>
 * This class in only meant to be used in cases where it is ok for the client to
 * receive <code>null</code> as the new hint value. In other cases clients
 * should simply implement IHintListener.
 * </p>
 *
 * @author Tuukka Lehtonen
 */
public abstract class HintListenerAdapter implements IHintListener {

	@Override
	public void hintRemoved(IHintObservable sender, Key key, Object oldValue) {		
		hintChanged(sender, key, oldValue, null);
	}
	
}

