/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SetUnion<T> extends ImmutableCollection<T> {

    private Set<T> set1;
    private Set<T> set2;    
    
    public SetUnion(Set<T> set1, Set<T> set2) {
        this.set1 = set1;
        this.set2 = set2;
    }

    @Override
    public boolean contains(Object o) {
        return set1.contains(o) || set2.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for(Object o : c)
            if(!contains(o))
                return false;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return set1.isEmpty() && set2.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new ImmutableIterator<T>() {

            int setId = 0;
            Iterator<T> it1 = set1.iterator();
            Iterator<T> it2 = set2.iterator();
            T element = null;
            
            @Override
            public boolean hasNext() {
                if(setId == 0) {
                    if(it1.hasNext())
                        return true;
                    else {
                        setId = 1;
                        return hasNext();
                    }
                }
                else {
                    if(element != null)
                        return true;
                    while(it2.hasNext()) {                            
                        element = it2.next();
                        if(set1.contains(element)) 
                            element = null;
                        else
                            return true;
                    }
                    return false;
                }
            }

            @Override
            public T next() {
                if(setId == 0) {
                    if(it1.hasNext())
                        return it1.next();
                    else {
                        setId = 1;
                        return next();
                    }
                }
                else {
                    if(element != null) {
                        T ret = element;
                        element = null;
                        return ret;
                    }
                    while(it2.hasNext()) {                            
                        T ret = it2.next();
                        if(!set1.contains(ret)) 
                            return ret;
                    }
                    return null;
                }
            }
            
        };
    }

    @Override
    public int size() {
        int count = set1.size();       
        for(T o : set2)
            if(!set1.contains(o))
                ++count;
        return count;
    }       
    
}
