/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;

/**
 * Collection with at most 2 elements. Does not use equals for comparison.
 */
public class Max2Collection<T> implements Collection<T> {

    public T first;
    public T second;    
    
    static class CollectionIsFullException extends RuntimeException {

        private static final long serialVersionUID = 8693601196559590064L;
        
    }        
    
    public Max2Collection() {        
    }
            
    public Max2Collection(T first, T second) {
        this.first = first;
        this.second = second;
    }

    public Max2Collection(T first) {
        this.first = first;
    }

    final public T get(int i) {
        if(i==0)
            return first;
        else if(i==1)
            return second;
        else
            throw new IndexOutOfBoundsException();
    }
    
    final public T getOther(T el) {
        if(first != el)
            return first;
        else
            return second;        
    }
    
    final public boolean add(T el) {
        if(first == null)
            first = el;
        else if(second == null)
            second = el;
        else
            throw new CollectionIsFullException();
        return true;
    }
    
    final public boolean remove(Object el) {
        if(first == el) {
            first = second;
            second = null;
            return true;
        }
        else if(second == el) {
            second = null;
            return true;
        }
        else
            return false;        
    }
    
    final public void setFirstElement(T el) {
        if(second == el) {
            second = first;
            first = el;
        }               
    }
    
    final public void setSecondElement(T el) {
        if(first == el) {
            first = second;
            second = el;
        }
                
    }
    
    final public int size() {
        if(first == null)
            return 0;
        else if(second == null)
            return 1;
        else
            return 2;
    }
    
    final public boolean isEmpty() {
        return first == null;
    }
    
    final public boolean isFull() {
        return second != null;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {        
        for(T o : c)
            add(o);
        return !c.isEmpty();
    }

    @Override
    public void clear() {
        first = null;
        second = null; // necessary for gc
    }

    @Override
    public boolean contains(Object o) {
        return first == o || second == o;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for(Object o : c)
            if(!contains(o))
                return false;
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for(Object o : c)
            removed |= remove(o);
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        if(first == null)
            return new Object[0];
        if(second == null)
            return new Object[] {first};
        else
            return new Object[] {first, second};        
    }

    @SuppressWarnings("hiding")
    @Override
    public <T> T[] toArray(T[] a) {       
        throw new UnsupportedOperationException();
    }
    
}
