/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.SerialisationSupport;

final class ResourceInputs {
    ResourceInputs() {
    }

    public static <T> Reference<T> makeReference(T t) {
        return new SoftReference<T>(t);
    }

    public static Resource resolveResource(RequestProcessor processor, String resourceId) throws DatabaseException {
        try {
            SerialisationSupport ss = (SerialisationSupport)processor.getService(SerialisationSupport.class);
            return ss.getResource(Long.parseLong(resourceId));
        }
        catch (NumberFormatException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static ResourceArray makeResourceArray(RequestProcessor processor, Collection<String> resourceIds) throws DatabaseException {
        try {
            SerialisationSupport ss = (SerialisationSupport)processor.getService(SerialisationSupport.class);
            ArrayList<Resource> rs = new ArrayList<Resource>();
            for (String id : resourceIds) {
                rs.add(ss.getResource(Long.parseLong(id)));
            }
            return new ResourceArray(rs);
        }
        catch (NumberFormatException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static String getRandomAccessId(Resource r) {
        try {
            SerialisationSupport support = (SerialisationSupport)ResourceInputs.getSession().getService(SerialisationSupport.class);
            return String.valueOf(support.getRandomAccessId(r));
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public static List<String> getRandomAccessIds(ResourceArray ra) {
        try {
            ArrayList<String> randoms = new ArrayList<String>();
            SerialisationSupport support = (SerialisationSupport)ResourceInputs.getSession().getService(SerialisationSupport.class);
            Resource[] resourceArray = ra.resources;
            int n = ra.resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource r = resourceArray[n2];
                randoms.add(String.valueOf(support.getRandomAccessId(r)));
                ++n2;
            }
            return Collections.unmodifiableList(randoms);
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public static Session getSession() {
        Session s = Simantics.getSession();
        if (((LifecycleSupport)s.getService(LifecycleSupport.class)).isClosed()) {
            throw new IllegalStateException("database session is closed");
        }
        return s;
    }

    public static Session peekSession() {
        Session s = Simantics.peekSession();
        if (s == null) {
            return null;
        }
        if (((LifecycleSupport)s.getService(LifecycleSupport.class)).isClosed()) {
            throw new IllegalStateException("database session is closed");
        }
        return s;
    }
}

