/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.ui.icons.ImageDescriptorProvider;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorInputFactory;
import org.simantics.ui.workbench.ResourceInputs;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.StringMemento;

public class ResourceEditorInput
extends PlatformObject
implements IResourceEditorInput,
IPersistableElement {
    static final String NO_NAME = "(no name)";
    private final String editorID;
    private List<String> resourceIds;
    private transient Reference<ResourceArray> resources;
    private transient boolean exists;
    private transient String name;
    private transient String tooltip;
    private transient ImageDescriptor imageDesc;
    private final StringMemento persistentStore = new StringMemento();

    public ResourceEditorInput(String editorID, Resource r) {
        this(editorID, new ResourceArray(new Resource[]{r}));
    }

    public ResourceEditorInput(String editorID, ResourceArray ra) {
        if (editorID == null) {
            throw new IllegalArgumentException("null editor id");
        }
        if (ra == null) {
            throw new IllegalArgumentException("null resource array");
        }
        if (ra.isEmpty()) {
            throw new IllegalArgumentException("input resource array is empty, expected non-empty list");
        }
        Resource[] resourceArray = ra.resources;
        int n = ra.resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (r == null) {
                throw new IllegalArgumentException("input resource array contains null resources: " + ra);
            }
            ++n2;
        }
        this.editorID = editorID;
        this.resources = ResourceInputs.makeReference(ra);
        this.resourceIds = ResourceInputs.getRandomAccessIds(ra);
        this.setNonExistant();
    }

    public ResourceEditorInput(String editorID, String randomAccessResourceId) {
        this(editorID, Collections.singletonList(randomAccessResourceId));
    }

    public ResourceEditorInput(String editorID, List<String> randomAccessResourceId) {
        if (randomAccessResourceId == null) {
            throw new IllegalArgumentException("null resource id list");
        }
        if (randomAccessResourceId.isEmpty()) {
            throw new IllegalArgumentException("input resource id list is empty, expected non-empty list");
        }
        for (String id : randomAccessResourceId) {
            if (id != null) continue;
            throw new IllegalArgumentException("input resource id list contains null IDs: " + randomAccessResourceId);
        }
        this.editorID = editorID;
        if (editorID == null) {
            editorID = "";
        }
        this.resourceIds = Collections.unmodifiableList(new ArrayList<String>(randomAccessResourceId));
        this.resources = ResourceInputs.makeReference(ResourceArray.EMPTY);
        this.setNonExistant();
    }

    @Override
    public void init(IAdaptable adapter) throws DatabaseException {
        ResourceArray ra = this.getResourceArray();
        if (!ra.isEmpty()) {
            this.updateCaches(true);
        }
    }

    @Override
    public void dispose() {
        this.resources = null;
    }

    public boolean exists() {
        return this.exists;
    }

    @Override
    public boolean exists(ReadGraph graph) throws DatabaseException {
        Resource[] resourceArray = this.getResourceArray().resources;
        int n = this.getResourceArray().resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (!graph.hasStatement(r)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Resource getResource() {
        ResourceArray ra = this.getResourceArray();
        return ra.isEmpty() ? null : ra.resources[0];
    }

    public ResourceArray getResourceArray0() throws DatabaseException {
        ResourceArray ra = this.tryGetResourceArray();
        if (!ra.isEmpty()) {
            return ra;
        }
        Session s = ResourceInputs.peekSession();
        if (s == null) {
            return ResourceArray.EMPTY;
        }
        ra = ResourceInputs.makeResourceArray((RequestProcessor)s, this.resourceIds);
        this.resources = ResourceInputs.makeReference(ra);
        return ra;
    }

    @Override
    public ResourceArray getResourceArray() {
        try {
            return this.getResourceArray0();
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return ResourceArray.EMPTY;
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDesc;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public IPersistableElement getPersistable() {
        if (!this.isPersistable()) {
            return null;
        }
        return this;
    }

    protected boolean isPersistable() {
        Session session = Simantics.peekSession();
        if (session == null) {
            return false;
        }
        LifecycleSupport lc = (LifecycleSupport)session.peekService(LifecycleSupport.class);
        if (lc == null) {
            return false;
        }
        return !lc.isClosed();
    }

    public String getFactoryId() {
        return ResourceEditorInputFactory.getFactoryId();
    }

    public void saveState(IMemento memento) {
        for (String id : this.resourceIds) {
            IMemento child = memento.createChild("resourceId");
            child.putTextData(id);
        }
        memento.putString("editorId", this.editorID);
        memento.putString("external", this.persistentStore.toString());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.editorID.hashCode();
        result = 31 * result + Objects.hashCode(this.resourceIds);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceEditorInput other = (ResourceEditorInput)obj;
        if (!this.editorID.equals(other.editorID)) {
            return false;
        }
        return Objects.equals(this.resourceIds, other.resourceIds);
    }

    private void updateCaches(boolean sync) throws DatabaseException {
        ReadRequest req = new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                ResourceEditorInput.this.update(g);
            }
        };
        Session s = ResourceInputs.getSession();
        if (sync) {
            s.syncRequest((Read)req);
        } else {
            s.asyncRequest((Read)req);
        }
    }

    @Override
    public void update(ReadGraph g) throws DatabaseException {
        Resource r = this.getResource();
        if (r == null) {
            return;
        }
        this.exists = g.hasStatement(r);
        if (this.exists) {
            this.name = (String)g.syncRequest((Read)new TitleRequest(this.editorID, this));
            if (this.name == null) {
                this.name = NO_NAME;
            }
            this.tooltip = (String)g.syncRequest((Read)new ToolTipRequest(this.editorID, this));
            if (this.tooltip == null) {
                this.tooltip = NO_NAME;
            }
            try {
                ImageDescriptorProvider idp = (ImageDescriptorProvider)g.adapt(r, ImageDescriptorProvider.class);
                this.imageDesc = (ImageDescriptor)idp.get();
            }
            catch (AdaptionException adaptionException) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
            }
            catch (ProvisionException e) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
                ErrorLogger.defaultLogError((Throwable)e);
            }
        } else {
            this.setNonExistant();
        }
    }

    private void setNonExistant() {
        this.exists = false;
        this.name = NO_NAME;
        this.tooltip = NO_NAME;
        this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
    }

    public IMemento getPersistentStore() {
        return this.persistentStore;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [name=" + this.getName() + ", resourceIds=" + this.resourceIds + ", resources=" + this.resources + "]";
    }

    private ResourceArray tryGetResourceArray() {
        Reference<ResourceArray> ref = this.resources;
        if (ref == null) {
            return ResourceArray.EMPTY;
        }
        ResourceArray ra = ref.get();
        return ra == null ? ResourceArray.EMPTY : ra;
    }
}

