/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workspace.tracker.internal.contributions;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.simantics.filesystem.services.sizetracker.SizeTracker;
import org.simantics.ui.workspace.tracker.internal.contributions.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceSizeTrackerTrim
extends Composite {
    private Logger logger = LoggerFactory.getLogger(WorkspaceSizeTrackerTrim.class);
    private MToolControl toolControl;
    private SizeTracker sizeTracker;
    private IPreferenceStore prefStore;
    private long lowSpaceThreshold = 500L;
    private boolean highlightLowSpace = true;
    private int updateInterval = 1000;
    private Color bgCol;
    private Color usedSpaceCol;
    private Color lowSpaceCol;
    private Color topLeftCol;
    private Color bottomRightCol;
    private Color sepCol;
    private Color textCol;
    private Color markCol;
    private String storeName;
    private long totalSpace;
    private long availableSpace;
    private long usedSpace;
    private long prevTotalSpace = -1L;
    private long prevAvailableSpace = -1L;
    private long prevUsedSpace = -1L;
    private boolean hasChanged;
    private long mark = -1L;
    private boolean updateTooltip = false;
    private final Runnable timer = new Runnable(){

        @Override
        public void run() {
            if (!WorkspaceSizeTrackerTrim.this.isDisposed()) {
                WorkspaceSizeTrackerTrim.this.safeUpdateStats();
                if (WorkspaceSizeTrackerTrim.this.hasChanged) {
                    if (WorkspaceSizeTrackerTrim.this.updateTooltip) {
                        WorkspaceSizeTrackerTrim.this.updateToolTip();
                    }
                    WorkspaceSizeTrackerTrim.this.redraw();
                    WorkspaceSizeTrackerTrim.this.hasChanged = false;
                }
                WorkspaceSizeTrackerTrim.this.getDisplay().timerExec(WorkspaceSizeTrackerTrim.this.updateInterval, (Runnable)this);
            }
        }
    };
    private final IPropertyChangeListener prefListener = event -> {
        boolean show;
        if ("WorkspaceSizeTracker.updateInterval".equals(event.getProperty())) {
            this.setUpdateIntervalInMS(this.prefStore.getInt("WorkspaceSizeTracker.updateInterval"));
        } else if ("WorkspaceSizeTracker.highlightLowSpace".equals(event.getProperty())) {
            this.highlightLowSpace = this.prefStore.getBoolean("WorkspaceSizeTracker.highlightLowSpace");
            this.hasChanged = true;
        } else if ("WorkspaceSizeTracker.lowSpaceThreshold".equals(event.getProperty())) {
            this.lowSpaceThreshold = this.prefStore.getLong("WorkspaceSizeTracker.lowSpaceThreshold");
            this.hasChanged = true;
        } else if ("WorkspaceSizeTracker.showMonitor".equals(event.getProperty()) && !(show = this.prefStore.getBoolean("WorkspaceSizeTracker.showMonitor"))) {
            this.showTracker(false);
        }
    };

    public WorkspaceSizeTrackerTrim(Composite parent, MToolControl toolControl, SizeTracker sizeTracker, IPreferenceStore prefStore) {
        super(parent, 0);
        this.toolControl = toolControl;
        this.sizeTracker = sizeTracker;
        this.prefStore = prefStore;
        prefStore.addPropertyChangeListener(this.prefListener);
        this.setUpdateIntervalInMS(prefStore.getInt("WorkspaceSizeTracker.updateInterval"));
        this.highlightLowSpace = prefStore.getBoolean("WorkspaceSizeTracker.highlightLowSpace");
        this.lowSpaceThreshold = prefStore.getLong("WorkspaceSizeTracker.lowSpaceThreshold");
        Display display = this.getDisplay();
        this.usedSpaceCol = display.getSystemColor(18);
        this.lowSpaceCol = new Color((Device)display, 255, 70, 70);
        this.bgCol = display.getSystemColor(22);
        this.sepCol = this.topLeftCol = display.getSystemColor(18);
        this.bottomRightCol = display.getSystemColor(20);
        this.markCol = this.textCol = display.getSystemColor(21);
        this.createContextMenu();
        Listener listener = event -> {
            switch (event.type) {
                case 12: {
                    this.doDispose();
                    break;
                }
                case 9: {
                    if (event.widget != this) break;
                    this.paintComposite(event.gc);
                    break;
                }
                case 3: {
                    if (event.button != 1 || event.widget != this) break;
                    this.setMark();
                    break;
                }
                case 6: {
                    this.updateTooltip = true;
                    this.updateToolTip();
                    break;
                }
                case 7: {
                    if (event.widget != this) break;
                    this.updateTooltip = false;
                }
            }
        };
        this.addListener(12, listener);
        this.addListener(3, listener);
        this.addListener(9, listener);
        this.addListener(6, listener);
        this.addListener(7, listener);
        this.safeUpdateStats();
        this.getDisplay().asyncExec(() -> {
            if (!this.isDisposed()) {
                this.getDisplay().timerExec(this.updateInterval, this.timer);
            }
        });
    }

    public void setBackground(Color color) {
        this.bgCol = color;
    }

    public void setForeground(Color color) {
        this.markCol = color == null ? (this.textCol = this.getDisplay().getSystemColor(29)) : (this.textCol = color);
    }

    public Color getForeground() {
        if (this.usedSpaceCol != null) {
            return this.usedSpaceCol;
        }
        return this.getDisplay().getSystemColor(29);
    }

    private void setUpdateIntervalInMS(int interval) {
        this.updateInterval = Math.max(100, interval);
    }

    private void doDispose() {
        this.prefStore.removePropertyChangeListener(this.prefListener);
        if (this.lowSpaceCol != null) {
            this.lowSpaceCol.dispose();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this);
        Point p = gc.textExtent(Messages.WorkspaceSizeTrackerTrim_widthStr);
        int height = p.y + 4;
        gc.dispose();
        return new Point(p.x, height);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(menuMgr1 -> this.fillMenu(menuMgr1));
        Menu menu = menuMgr.createContextMenu((Control)this);
        this.setMenu(menu);
    }

    private void fillMenu(IMenuManager menuMgr) {
        menuMgr.add((IAction)new SetMarkAction());
        menuMgr.add((IAction)new ClearMarkAction());
        menuMgr.add((IAction)new CloseSizeTrackerTrimAction());
    }

    private void setMark() {
        this.safeUpdateStats();
        this.mark = this.usedSpace;
        this.hasChanged = true;
        this.redraw();
    }

    private void clearMark() {
        this.mark = -1L;
        this.hasChanged = true;
        this.redraw();
    }

    private void paintComposite(GC gc) {
        this.paintCompositeMaxUnknown(gc);
    }

    private void paintCompositeMaxUnknown(GC gc) {
        Rectangle rect = this.getClientArea();
        int x = rect.x;
        int y = rect.y;
        int w = rect.width;
        int h = rect.height;
        int sw = w - 1;
        long storeUsedSpace = this.totalSpace - this.availableSpace;
        int uw = (int)((long)sw * storeUsedSpace / this.totalSpace);
        int ux = x + 1 + uw;
        if (this.bgCol != null) {
            gc.setBackground(this.bgCol);
        }
        gc.fillRectangle(rect);
        boolean lowOnSpace = false;
        if (this.highlightLowSpace) {
            lowOnSpace = 0x100000L * this.lowSpaceThreshold >= this.availableSpace;
        }
        gc.setForeground(this.sepCol);
        gc.drawLine(ux, y, ux, y + h);
        gc.setForeground(this.topLeftCol);
        gc.drawLine(x, y, x + w, y);
        gc.drawLine(x, y, x, y + h);
        gc.setForeground(this.bottomRightCol);
        gc.drawLine(x + w - 1, y, x + w - 1, y + h);
        gc.drawLine(x, y + h - 1, x + w, y + h - 1);
        gc.setBackground(lowOnSpace ? this.lowSpaceCol : this.usedSpaceCol);
        gc.fillRectangle(x + 1, y + 1, uw, h - 2);
        String s = NLS.bind((String)Messages.WorkspaceSizeTrackerTrim_status, (Object)this.convertToSizeString(this.usedSpace), (Object)this.convertToSizeString(this.availableSpace));
        Point p = gc.textExtent(s);
        int sx = (rect.width - 15 - p.x) / 2 + rect.x + 1;
        int sy = (rect.height - 2 - p.y) / 2 + rect.y + 1;
        gc.setForeground(this.textCol);
        gc.drawString(s, sx, sy, true);
    }

    private void safeUpdateStats() {
        try {
            this.updateStats();
        }
        catch (IOException e) {
            this.logger.error("Failed to update workspace size statistics.", (Throwable)e);
        }
    }

    private void updateStats() throws IOException {
        Path path = this.sizeTracker.path();
        FileStore store = Files.getFileStore(path);
        this.storeName = store.toString();
        this.totalSpace = store.getTotalSpace();
        this.availableSpace = store.getUsableSpace();
        this.usedSpace = this.sizeTracker.size();
        if (this.convertToMeg(this.prevTotalSpace) != this.convertToMeg(this.totalSpace)) {
            this.prevTotalSpace = this.totalSpace;
            this.hasChanged = true;
        }
        if (this.prevAvailableSpace != this.availableSpace) {
            this.prevAvailableSpace = this.availableSpace;
            this.hasChanged = true;
        }
        if (this.convertToMeg(this.prevUsedSpace) != this.convertToMeg(this.usedSpace)) {
            this.prevUsedSpace = this.usedSpace;
            this.hasChanged = true;
        }
    }

    private void updateToolTip() {
        String markStr;
        String totalStr;
        String availableStr;
        String usedStr = this.convertToSizeString(this.usedSpace);
        String toolTip = NLS.bind((String)Messages.WorkspaceSizeTrackerTrim_memoryToolTip, (Object[])new Object[]{usedStr, this.storeName, availableStr = this.convertToSizeString(this.availableSpace), totalStr = this.convertToSizeString(this.totalSpace), markStr = this.mark == -1L ? Messages.WorkspaceSizeTrackerTrim_noMark : this.convertToSizeString(this.mark)});
        if (!toolTip.equals(this.getToolTipText())) {
            this.setToolTipText(toolTip);
        }
    }

    private String convertToSizeString(long numBytes) {
        long megs = this.convertToMeg(numBytes);
        if (megs > 10000L) {
            double megsd = megs;
            long gigs = (long)Math.floor(megsd / 1024.0);
            long decimals = (long)(megsd - (double)(gigs * 1024L));
            decimals = (decimals + 5L) / 10L;
            return NLS.bind((String)Messages.WorkspaceSizeTrackerTrim_gig, (Object)new Long(gigs), (Object)new Long(decimals));
        }
        return NLS.bind((String)Messages.WorkspaceSizeTrackerTrim_meg, (Object)new Long(megs));
    }

    private long convertToMeg(long numBytes) {
        return (numBytes + 524288L) / 0x100000L;
    }

    private void showTracker(boolean show) {
        if (this.toolControl.isToBeRendered() != show) {
            Object widget = this.toolControl.getWidget();
            Shell shell = widget instanceof Control ? ((Control)widget).getShell() : null;
            this.toolControl.setToBeRendered(show);
            if (shell != null) {
                shell.layout(null, 7);
            }
            this.prefStore.setValue("WorkspaceSizeTracker.showMonitor", show);
        }
    }

    class ClearMarkAction
    extends Action {
        ClearMarkAction() {
            super(Messages.ClearMarkAction_text);
        }

        public void run() {
            WorkspaceSizeTrackerTrim.this.clearMark();
        }
    }

    class CloseSizeTrackerTrimAction
    extends Action {
        CloseSizeTrackerTrimAction() {
            super(Messages.WorkspaceSizeTrackerTrim_close);
        }

        public void run() {
            WorkspaceSizeTrackerTrim.this.showTracker(false);
        }
    }

    class SetMarkAction
    extends Action {
        SetMarkAction() {
            super(Messages.SetMarkAction_text);
        }

        public void run() {
            WorkspaceSizeTrackerTrim.this.setMark();
        }
    }
}

