/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.simantics.g2d.utils.GridSpacing;
import org.simantics.g2d.utils.GridUtil;
import org.simantics.trend.configuration.ItemPlacement;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.impl.ItemNode;
import org.simantics.trend.impl.TrendGraphicalNode;
import org.simantics.trend.impl.TrendNode;
import org.simantics.utils.format.ValueFormat;

public class VertRuler
extends TrendGraphicalNode {
    private static final long serialVersionUID = 3773787909384380074L;
    GridSpacing spacing = GridSpacing.SOME_SPACING;
    double min = -1.0;
    double max = 1.0;
    double iMin = Double.MAX_VALUE;
    double iMax = -1.7976931348623157E308;
    String label = "";
    Color color = Color.GRAY;
    boolean autoscroll = true;
    boolean manualscale = false;
    double labelWidth = 7.0;
    List<String> extra_labels = new ArrayList<String>();
    List<Color> extra_label_colors = new ArrayList<Color>();
    double extra_width = 0.0;
    int singleAxisShowLegendsMaxLegends = 10;
    static final double TRIANGLE_SIZE = 7.0;
    static final Path2D TRIANGLE = new Path2D.Double();

    static {
        TRIANGLE.moveTo(-3.5, 0.0);
        TRIANGLE.lineTo(3.5, 0.0);
        TRIANGLE.lineTo(0.0, 7.0);
    }

    public void layout() {
        TrendNode trend = this.getTrend();
        ValueFormat vf = trend.valueFormat;
        this.spacing = GridSpacing.makeGridSpacing((double)(this.max - this.min), (double)this.getHeight(), (double)15.0);
        this.labelWidth = Math.max(7.0, GridUtil.calcLabelWidth((double)this.min, (double)this.max, (Format)vf.format, (GridSpacing)this.spacing));
        double w = 30.0 + this.labelWidth;
        double quantization = 10.0;
        int x = (int)Math.ceil(w / quantization);
        if (x < 4) {
            x = 4;
        }
        w = (double)x * quantization;
        this.bounds.setFrame(0.0, 0.0, w += 5.0, this.getHeight());
        trend.shapedirty = true;
    }

    public void addExtraLabel(String label, Color color) {
        this.extra_labels.add(label);
        this.extra_label_colors.add(color);
    }

    public void setHeight(double height) {
        if (height == this.bounds.getHeight()) {
            return;
        }
        this.bounds.setFrame(0.0, 0.0, this.bounds.getWidth(), height);
        this.getTrend().shapedirty = true;
    }

    @Override
    public double getWidth() {
        if (this.extra_labels.size() == 0) {
            return super.getWidth();
        }
        if (this.extra_width == 0.0) {
            this.extra_width = 15.0 * (double)this.extra_labels.size();
            double w = this.bounds.getWidth();
            return w + this.extra_width;
        }
        double w = this.bounds.getWidth();
        return w + this.extra_width;
    }

    public boolean setMinMax(double min, double max) {
        if (min == this.min && max == this.max) {
            return false;
        }
        this.spacing = GridSpacing.makeGridSpacing((double)(max - min), (double)this.getHeight(), (double)15.0);
        this.min = min;
        this.max = max;
        this.getTrend().shapedirty = true;
        return true;
    }

    @Override
    protected void doRender(Graphics2D g) {
        TrendNode trend = (TrendNode)this.getParent();
        VertRuler master = trend.vertRuler;
        VertRuler slave = this;
        if (!trend.printing) {
            g.setColor(Color.LIGHT_GRAY);
            g.setFont(RULER_FONT);
            String txt = !this.autoscroll ? (this.manualscale ? "*" : "Auto off") : (this.manualscale ? "" : "Auto on");
            g.drawString(txt, 5.0f, -9.0f);
        }
        g.setPaint(this.color);
        g.setStroke(GridUtil.RULER_LINE_STROKE);
        ValueFormat vf = trend.valueFormat;
        if (master != slave) {
            int tickCount = GridUtil.getTickCount((GridSpacing)master.spacing, (double)master.min, (double)master.getHeight());
            int noOfDecimals = VertRuler.calcNoOfDecimals(tickCount, slave.max - slave.min);
            Format format = vf.toFormat(noOfDecimals);
            GridUtil.paintVerticalSlaveRuler((GridSpacing)master.spacing, (GridSpacing)this.spacing, (Graphics2D)g, (double)master.min, (double)slave.min, (double)this.getHeight(), (Format)format);
        } else {
            NumberFormat format = vf.format;
            GridUtil.paintVerticalRuler((GridSpacing)this.spacing, (Graphics2D)g, (double)this.min, (double)this.getHeight(), (Format)format);
        }
        boolean selected = trend.singleAxis ? false : trend.vertRuler == this;
        Font font = (selected &= !trend.printing) ? RULER_FONT_BOLD : RULER_FONT;
        FontMetrics fm = g.getFontMetrics(font);
        if (this.extra_labels.size() == 0) {
            double wid = fm.stringWidth(this.label);
            AffineTransform at = g.getTransform();
            g.translate(this.getWidth() - 15.0, (this.getHeight() - wid) / 2.0);
            g.transform(AffineTransform.getQuadrantRotateInstance(1));
            g.setColor(this.color);
            g.setFont(font);
            g.drawString(this.label, 0.0f, 0.0f);
            g.setTransform(at);
            if (selected) {
                at = g.getTransform();
                g.translate(this.getWidth() - 7.0 - 5.0, 0.0);
                g.setColor(this.color);
                g.fill(TRIANGLE);
                g.setTransform(at);
            }
        } else {
            this.extra_width = 0.0;
            double bounds_width = this.bounds.getWidth();
            int label_index = 0;
            while (label_index < this.extra_labels.size()) {
                if (label_index >= this.singleAxisShowLegendsMaxLegends) break;
                String label = this.extra_labels.get(label_index);
                Color color = this.extra_label_colors.get(label_index);
                double wid = fm.stringWidth(label);
                double font_height = fm.getHeight();
                this.extra_width += font_height;
                AffineTransform at = g.getTransform();
                g.translate(bounds_width + (double)label_index * font_height, (this.getHeight() - wid) / 2.0);
                g.transform(AffineTransform.getQuadrantRotateInstance(1));
                g.setColor(color);
                g.setFont(font);
                g.drawString(label, 0.0f, 0.0f);
                g.setTransform(at);
                ++label_index;
            }
        }
    }

    public void setKnownMinMax() {
        TrendNode trend = (TrendNode)this.getParent();
        this.iMax = -1.7976931348623157E308;
        this.iMin = Double.MAX_VALUE;
        for (ItemNode item : trend.analogItems) {
            if (item.item.renderer != TrendItem.Renderer.Analog || item.ruler != this) continue;
            if (!Double.isNaN(item.min)) {
                this.iMin = Math.min(this.iMin, item.min);
            }
            if (Double.isNaN(item.max)) continue;
            this.iMax = Math.max(this.iMax, item.max);
        }
        if (this.iMin == Double.MAX_VALUE && this.iMax == -1.7976931348623157E308) {
            this.iMin = 0.0;
            this.iMax = 1.0;
        }
    }

    public boolean autoscale() {
        if (!this.autoscroll) {
            return false;
        }
        this.setKnownMinMax();
        double nMin = this.iMin;
        double nMax = this.iMax;
        double diff = nMax - nMin;
        if (diff == 0.0) {
            diff = (nMax += 0.5) - (nMin -= 0.5);
        }
        double margin = diff * 0.02;
        TrendNode trend = this.getTrend();
        if (trend.itemPlacement == ItemPlacement.Stacked) {
            int c = trend.vertRulers.size();
            int i = c - trend.vertRulers.indexOf(this) - 1;
            nMin = nMin - diff * (double)i - margin;
            nMax = nMax + diff * (double)(c - i - 1) + margin;
        } else {
            nMin = this.iMin - margin;
            nMax = this.iMax + margin;
        }
        return this.setMinMax(nMin, nMax);
    }

    public void translate(double dy) {
        this.min += dy;
        this.max += dy;
        this.autoscroll = false;
    }

    public void zoomIn(double y, double height) {
        this.autoscroll = false;
        double diff = this.max - this.min;
        double sy = diff / this.getHeight();
        if (Math.abs(diff) < 1.0E-6 && height < this.getHeight()) {
            return;
        }
        double newMin = this.min + (this.getHeight() - y - height) * sy;
        double newMax = this.max - y * sy;
        this.setMinMax(newMin, newMax);
    }

    public void zoomOut() {
        this.autoscroll = true;
        this.autoscale();
    }

    public void zoomTo(double min, double max) {
        this.setMinMax(min, max);
        this.autoscroll = false;
    }

    public double unitsPerPixel() {
        return (this.max - this.min) / this.getHeight();
    }

    static int calcNoOfDecimals(int tickCount, double diff) {
        int interestingNumbers = tickCount <= 2 ? 1 : (tickCount >= 3 && tickCount <= 9 ? 2 : (tickCount >= 10 && tickCount <= 99 ? 3 : (tickCount >= 100 && tickCount <= 999 ? 4 : 5)));
        int decimals = interestingNumbers - (int)Math.ceil(Math.log10(diff));
        if (decimals < 0) {
            decimals = 0;
        }
        return decimals;
    }

    public static void main(String[] args) {
        double diff = 12.456789;
        int tickCount = 0;
        while (tickCount < 15) {
            int noOfDecimals = VertRuler.calcNoOfDecimals(tickCount, diff);
            Format format = ValueFormat.Currency.toFormat(noOfDecimals);
            System.out.println("diff=" + diff + ", tickcount=" + tickCount + ", #ofDecimals=" + noOfDecimals + ", formatted diff=" + format.format(diff));
            ++tickCount;
        }
    }
}

