/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.trend.configuration;

import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.util.Bean;

/**
 * Describes a viewport to a trend chart. 
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class TimeWindow extends Bean {

	/** Optional start position */
	public @Optional Double timeWindowStart;
	
	/** Optional length */
	public @Optional Double timeWindowLength;
	
	/** Optional, percent of how much window is grown once end is reached */
	public @Optional Double timeWindowIncrement;
	
}

