/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.tests.modelled.ui;

import java.text.DecimalFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.simantics.scl.compiler.module.coverage.Coverage;
import org.simantics.tests.modelled.ui.Activator;

public final class RedGreenBar {
    private static final int BORDER_LEFT = 2;
    private static final int BORDER_RIGHT = 10;
    private static final int BORDER_TOP = 3;
    private static final int BORDER_BOTTOM = 4;
    private static final String MAX_PERCENTAGE_STRING = new DecimalFormat("0.0 %").format(1.0);
    private static final ImageDescriptor redbar = Activator.getImageDescriptor("icons/redbar.gif");
    private static final ImageDescriptor greenbar = Activator.getImageDescriptor("icons/greenbar.gif");
    private static Image redbarIcon = Activator.createManagedImage(redbar);
    private static Image greenbarIcon = Activator.createManagedImage(greenbar);

    private RedGreenBar() {
    }

    public static void draw(Event event, int columnWith, Coverage coverage) {
        int maxTotal = coverage.getTotalCodeSize();
        if (maxTotal == 0) {
            return;
        }
        int maxWidth = RedGreenBar.getMaxWidth(event, columnWith);
        int redLength = maxWidth * coverage.getMissedCodeSize() / maxTotal;
        RedGreenBar.bar(event, redbarIcon, 0, redLength);
        int greenLength = maxWidth * coverage.getCoveredCodeSize() / maxTotal;
        RedGreenBar.bar(event, greenbarIcon, redLength, greenLength);
    }

    private static void bar(Event event, Image image, int xOffset, int width) {
        int height = event.getBounds().height - 3 - 4;
        event.gc.drawImage(image, 0, 0, 1, 10, event.x + xOffset + 2, event.y + 3, width, height);
    }

    private static int getMaxWidth(Event event, int columnWith) {
        int textWidth = event.gc.textExtent((String)RedGreenBar.MAX_PERCENTAGE_STRING).x;
        int max = columnWith - 2 - 10 - textWidth;
        return Math.max(0, max);
    }
}

