/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.swt.graphics.Image;
import org.simantics.db.Operation;
import org.simantics.db.Session;
import org.simantics.db.UndoContext;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.team.internal.Images;
import org.simantics.team.ui.UndoCombinedElement;
import org.simantics.team.ui.UndoViewElement;

class UndoContextElement
extends UndoViewElement {
    protected String name = "Undo";
    protected WeakReference<UndoContext> contextRef;

    UndoContextElement(Session session, UndoContext context) {
        super(session);
        this.contextRef = new WeakReference<UndoContext>(context);
    }

    @Override
    protected Image getIdImage() {
        return Images.getInstance().OTHER_IMAGE;
    }

    @Override
    protected String getIdText() {
        String s = this.toString();
        return s.substring(0, Math.min(10, s.length()));
    }

    @Override
    boolean hasChildren() {
        UndoContext c = (UndoContext)this.contextRef.get();
        if (c == null) {
            return false;
        }
        try {
            return c.getAll().size() > 0;
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return false;
        }
    }

    public String toString() {
        UndoContext c = (UndoContext)this.contextRef.get();
        if (c == null) {
            return String.valueOf(this.name) + "@no context";
        }
        return String.valueOf(this.name) + "@" + c;
    }

    @Override
    Object[] getChildren() {
        Collection operations;
        UndoContext c = (UndoContext)this.contextRef.get();
        if (c == null) {
            return new Object[0];
        }
        try {
            operations = c.getAll();
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return new Object[0];
        }
        if (operations.size() < 1) {
            return new Object[0];
        }
        Object[] objects = new Object[operations.size()];
        Iterator it = operations.iterator();
        int i = operations.size();
        while (it.hasNext()) {
            Operation op = (Operation)it.next();
            objects[--i] = new UndoCombinedElement(this.session, op);
        }
        assert (i == 0);
        return objects;
    }
}

