/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.team.ui;

import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.TeamSupport;
import org.simantics.team.Utils;
import org.simantics.team.ui.StagingContextElement;
import org.simantics.team.ui.TreeElement;

class CommentContentProvider
implements ITreeContentProvider {
    protected Viewer viewer = null;
    private final Vector<String> comments = new Vector();
    private final Session session;
    private final TeamSupport teamSupport;

    CommentContentProvider(Session session) {
        this.session = session;
        this.teamSupport = (TeamSupport)this.session.getService(TeamSupport.class);
        try {
            this.teamSupport.getComments(Utils.getTeamFolder(), this.comments);
        }
        catch (DatabaseException e) {
            this.comments.add(e.getMessage());
        }
    }

    protected Object[] getElements() {
        int SIZE = this.comments.size();
        Object[] objects = new Object[SIZE];
        int i = 0;
        while (i < SIZE) {
            objects[i] = new StagingContextElement(i, this.comments.get(i));
            ++i;
        }
        return objects;
    }

    public void dispose() {
        this.viewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeElement) {
            return ((TreeElement)parentElement).getChildren();
        }
        return null;
    }

    public Object getParent(Object childElement) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeElement) {
            return ((TreeElement)element).hasChildren();
        }
        return false;
    }
}

