package org.simantics.structural.synchronization.internal;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

/**
 * @author Tuukka Lehtonen
 */
public final class Policy {

	public static final String PLUGIN_ID = "org.simantics.structural.synchronization";

	//public static boolean TRACE_EVENTS = false;

	static {
		//String sTrue = Boolean.TRUE.toString();
		//DEBUG_... = sTrue.equalsIgnoreCase(Platform.getDebugOption(PLUGIN_ID + "/debug/synchronization/...")); //$NON-NLS-1$
	}

	public static ILog getLog() {
		Bundle b = Platform.getBundle(PLUGIN_ID);
		if (b != null)
			return Platform.getLog(b);
		throw new IllegalStateException("bundle " + PLUGIN_ID + " not resolved");
	}

	public static void log(IStatus status) {
		getLog().log(status);
	}

	public static void log(int severity, String message, Throwable t) {
		getLog().log(new Status(severity, PLUGIN_ID, message, t));
	}

	public static void logError(String message, Throwable t) {
		log(IStatus.ERROR, message, t);
	}

	public static void logError(Throwable t) {
		logError(t.getMessage(), t);
	}

	public static void logWarning(String message, Throwable t) {
		log(IStatus.WARNING, message, t);
	}

	public static void logWarning(Throwable t) {
		logWarning(t.getMessage(), t);
	}

}