package org.simantics.spreadsheet.ui;
/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.graph.GraphUI;


public class DeleteHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {

		IAdaptable editor = (IAdaptable)HandlerUtil.getActiveEditor(event);
		if(editor == null) return null;

		Spreadsheet sheet = (Spreadsheet)editor.getAdapter(Spreadsheet.class);
		if(sheet == null) return null;

		int[] cols = sheet.getModel().getTable().getSelectedColumns();
		int[] rows = sheet.getModel().getTable().getSelectedRows();

		GraphUI ui = (GraphUI)editor.getAdapter(GraphUI.class);
		CellEditor ce = (CellEditor)ui.getAdapter(CellEditor.class);

		for(int row : rows) {
			for(int col : cols) {
				ce.edit(null, Spreadsheets.cellName(row, col), ClientModel.CONTENT, null, null);
			}
		}

		return null;

	}


}
