package org.simantics.spreadsheet.solver;

import java.util.Collections;
import java.util.Map;

import org.simantics.databoard.binding.mutable.Variant;

@SuppressWarnings("rawtypes")
public class SpreadsheetCellEditable implements SheetNode {

    private static final long serialVersionUID = -5078387091775971986L;
    
    public final SpreadsheetCell cell;

    public SpreadsheetCellEditable(SpreadsheetCell spreadsheetCell) {
        this.cell = spreadsheetCell;
    }

    @Override
    public String getName() {
        return "editable";
    }

    @Override
    public Map getChildren() {
        return Collections.emptyMap();
    }

    @Override
    public Map getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((cell == null) ? 0 : cell.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        SpreadsheetCellEditable other = (SpreadsheetCellEditable) obj;
        if (cell == null) {
            if (other.cell != null)
                return false;
        } else if (!cell.equals(other.cell))
            return false;
        return true;
    }

    public boolean editable() {
        if (cell.getContent() == null || cell.getContent() instanceof SpreadsheetFormula || cell.getContent() instanceof SpreadsheetSCLConstant)
            return false;
        if (cell.getContent() instanceof String) {
            String content = (String) cell.getContent();
            if (content.isEmpty())
                return false;
        }
        if (cell.getContent() instanceof Variant) {
            Variant content = (Variant) cell.getContent();
            if (content.getValue() == null)
                return false;
            if (content.getValue() instanceof String) {
                String actualContent = (String) content.getValue();
                if (actualContent.isEmpty())
                    return false;
            }
        }
//        System.out.println("content is " + cell.content);
        return true;
    }

}
