package org.simantics.spreadsheet;

import java.util.List;
import java.util.function.Consumer;

public interface Transaction<O> {

    void setContext(String key, Object context);

    <T> T getContext(String key);

    void add(O operation);

    /*
     * Applies the operations collected with this transaction
     * 
     */
    void commit(boolean sync) throws Exception;

    boolean isOperationMode();

    List<Object> needSynchronization();

    void needSynchronization(Object synchronizable);
    
    @Deprecated
    void commit();
    
    void addCommitListener(Consumer<Transaction<O>> listener);

}