/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.function;

import java.util.List;
import java.util.function.Consumer;
import org.simantics.databoard.binding.mutable.MutableVariant;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Write;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.Transaction;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.celleditor.VariableCellEditorBase;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

class SpreadsheetVariableCellEditor
extends VariableCellEditorBase {
    public SpreadsheetVariableCellEditor(Variable spreadsheet) {
        super(spreadsheet);
    }

    @Override
    public void edit(final Transaction<Write> transaction, final String location, final String property, final Variant variant, final Consumer<?> callback) {
        SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                CellEditor<Write> editor = SpreadsheetVariableCellEditor.this.getPossibleCellEditor((Transaction<Write>)transaction, graph, location, variant);
                if (editor == null) {
                    return;
                }
                editor.edit(transaction, location, property, variant, callback);
            }
        });
    }

    private CellEditor<Write> getPossibleCellEditor(Transaction<Write> transaction, WriteGraph graph, String location, Variant value) throws DatabaseException {
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        Range range = SpreadsheetUtils.decodePossibleCellAbsolute((String)location);
        if (range == null) {
            return null;
        }
        List<Variable> cells = SpreadsheetGraphUtils.possibleConfigurationCellVariables((ReadGraph)graph, this.configurationCell, range);
        if (cells.isEmpty()) {
            if (value == null) {
                return null;
            }
            cells = SpreadsheetGraphUtils.getOrCreateConfigurationCellVariables(graph, this.configurationCell, range);
            for (Variable cell : cells) {
                transaction.needSynchronization((Object)cell);
            }
        }
        if (cells.size() != 1) {
            throw new DatabaseException("Can edit only one cell at a time!");
        }
        return (CellEditor)cells.iterator().next().getPropertyValue((ReadGraph)graph, SHEET.cellEditor);
    }

    @Override
    public void copy(final Transaction<Write> transaction, final String location, final MutableVariant variant, Consumer<?> callback) {
        SpreadsheetUtils.schedule(transaction, (Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                CellEditor editor;
                SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
                Variable child = SpreadsheetVariableCellEditor.this.configurationCell.getPossibleChild((ReadGraph)graph, location);
                if (child != null && (editor = (CellEditor)child.getPossiblePropertyValue((ReadGraph)graph, SHEET.cellEditor)) != null) {
                    editor.copy(transaction, location, variant, null);
                }
            }
        });
    }
}

