package org.simantics.spreadsheet.graph.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.common.cell.VariableCellEditor;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class DoubleArrayCellVariable extends ConstantChildVariable {

    public DoubleArrayCellVariable(Variable parent, String name, String[] properties, Binding[] bindings, Object ... values) {
    	super(parent, name, properties, bindings, values);
    }
    
    @SuppressWarnings("unchecked")
    protected <T> T tryAdapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
    	if(VariableCellEditor.class == clazz) {
    		return (T)new VariableCellEditor() {
				
				@Override
				public void edit(WriteGraph graph, Variable cell, String text) throws DatabaseException {
					
					SpreadsheetResource sr = SpreadsheetResource.getInstance(graph);
					Resource configuration = cell.getPossibleRepresents(graph);
					double[] data = graph.getPossibleRelatedValue(configuration, sr.DoubleArrayCell_HasDoubleArray, Bindings.DOUBLE_ARRAY);
					if(data == null) return;
					Integer width = graph.getPossibleRelatedValue(configuration, sr.DoubleArrayCell_HasWidth, Bindings.INTEGER);
					if(width == null) return;
					String baseLocation = graph.getPossibleRelatedValue(configuration, sr.HasLocation, Bindings.STRING);
					if(baseLocation == null) return;
					String editLocation = cell.getPossiblePropertyValue(graph, Variables.NAME);
					
					Range baseRange = Spreadsheets.decodeCellAbsolute(baseLocation);
					Range editRange = Spreadsheets.decodeCellAbsolute(editLocation);
					
					int x = editRange.startColumn - baseRange.startColumn;
					int y = editRange.startRow - baseRange.startRow;
					
					int height = data.length / width;
					
					if(x>=0 && x<width && y>=0 && y<height) {
						data[width*y+x] = Double.parseDouble(text);
					}
					
					graph.claimLiteral(configuration, sr.DoubleArrayCell_HasDoubleArray, data, Bindings.DOUBLE_ARRAY);
					
				}
				
				@Override
				public void copy(WriteGraph graph, Variable cell, String location) throws DatabaseException {
				}
				
			};
    	}
    	return null;
    }

    @Override
    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = tryAdapt(graph, clazz);
        return t != null ? t : super.adapt(graph, clazz);
    }

    @Override
    public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        return tryAdapt(graph, clazz);
    }

}
