package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class Sheets extends VariableRead<List<String>> {

	public Sheets(Variable variable) {
		super(variable);
	}

	@Override
	public List<String> perform(ReadGraph graph) throws DatabaseException {
		Resource book = variable.getParent(graph).getRepresents(graph);
		Layer0 L0 = Layer0.getInstance(graph);
		Collection<Resource> sheets = graph.syncRequest(new ObjectsWithType(book, L0.ConsistsOf, SpreadsheetResource.getInstance(graph).Spreadsheet));
		List<String> result = new ArrayList<>(sheets.size());
		sheets.forEach(sheet -> {
		    try {
                String name = graph.getPossibleRelatedValue(sheet, L0.HasName, Bindings.STRING);
                result.add(name);
            } catch (Exception e) {
                e.printStackTrace();
            }
		});
		return result;
		
	}
	
}
