/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.spreadsheet.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.ConstantPropertyVariableBuilder;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.spreadsheet.ClientModel;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.utils.datastructures.Pair;

public class Cells extends UnaryRead<Variable, Collection<Pair<String, Variable>>> {

    public Cells(Variable variable) {
        super(variable);
    }

	private static Set<String> CLASSIFICATIONS = new HashSet<String>();
	
	static {
		CLASSIFICATIONS.add(SpreadsheetResource.URIs.Attribute);
	}
    
    @Override
    public Collection<Pair<String, Variable>> perform(ReadGraph graph) throws DatabaseException {
    	SpreadsheetResource SHEET = SpreadsheetResource.getInstance(graph);
    	ArrayList<Pair<String, Variable>> result = new ArrayList<Pair<String, Variable>>(); 
    	
    	if (GraphUI.DEBUG)
    	    System.out.println("Executing Cells for parameter " + parameter.getURI(graph));
    	
    	for(Variable child : parameter.getChildren(graph)) {
    		Resource type = child.getPossibleType(graph);
    		if(type != null) {
	    		if(graph.isInheritedFrom(type, SHEET.Range)) {
	    			
	    			try {
	    				
		    			Collection<Pair<String, Variable>> rangeCells = graph.sync(new Cells(child));
		    			result.addAll(rangeCells);
		    			
	    			} catch (DatabaseException e) {
	    				
	    	    		String location = child.getPossiblePropertyValue(graph, SHEET.Range_location, Bindings.STRING);
	    	    		if(location == null) location = "A1";
	    	    		
        				result.add(error(graph, child, location, e));
	    	    		
	    				Logger.defaultLogError(e);
	    			}
	    		} else if(graph.isInheritedFrom(type, SHEET.Cell)) {
	    			
	    			try {
	    				
		    			String name = child.getName(graph);
		    			result.add(Pair.make(name, child));

	    			} catch (DatabaseException e) {
	    			    if (GraphUI.DEBUG)
	    			        e.printStackTrace();
	    				Logger.defaultLogError(e);
	    				
	    			}
	    		}
    		}
    	}
    	for (Variable child : parameter.getParent(graph).getChildren(graph)) {
    	    
    	    Resource type = child.getPossibleType(graph);
    	    if (type != null)
    	    if (type != null && type.equals(SHEET.Style)) {
    	        String name = child.getName(graph);
    	        result.add(Pair.make(name, child));
    	    }
    	}
    	return result;
    }
    
    private static Pair<String, Variable> error(ReadGraph graph, Variable child, String location, DatabaseException e) throws DatabaseException {
    	
    	SpreadsheetResource SHEET = SpreadsheetResource.getInstance(graph);

		ArrayList<ConstantPropertyVariableBuilder> builders = new ArrayList<ConstantPropertyVariableBuilder>();
		
		builders.add(new ConstantPropertyVariableBuilder(ClientModel.CONTENT, Variant.ofInstance(e.getExplanation(graph)), Bindings.VARIANT, Collections.<ConstantPropertyVariableBuilder>emptyList(), CLASSIFICATIONS));
		builders.add(new ConstantPropertyVariableBuilder(Variables.TYPE, SHEET.Cell, null, Collections.<ConstantPropertyVariableBuilder>emptyList(), Collections.<String>emptySet()));
		
		Variable var = new ConstantChildVariable(child, location, builders);
		return new Pair<String, Variable>(location, var);

    }

}
