package org.simantics.simulator.toolkit;

import org.simantics.databoard.binding.Binding;
import org.simantics.simulation.sequences.action.AbstractActionContext;
import org.simantics.simulator.IDynamicExperimentLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicExperimentActionContext extends AbstractActionContext {

	private static final Logger LOGGER = LoggerFactory.getLogger(DynamicExperimentActionContext.class);

	final private IDynamicExperimentLocal experiment;
	
	public DynamicExperimentActionContext(IDynamicExperimentLocal experiment) {
		this.experiment = experiment;
	}
	
	@Override
	public Object get(String variableName, Binding binding) {
		return experiment.getVariableValueById(variableName);
	}

	@Override
	public void set(String variableName, Object value, Binding binding) {
		experiment.setVariableValueById(variableName, value, binding);
	}
	
	public IDynamicExperimentLocal getExperiment() {
	    return experiment;
	}

}
