/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.sequences.action;

/**
 * Reasons for why a simulation sequence stops.
 * 
 * <p>
 * {@link ActionContext#scheduleWhenStopped(org.simantics.scl.runtime.function.Function1)}
 * allows sequences to handle stop reasons.
 * 
 * @author Tuukka Lehtonen
 * @since 1.41.0, 1.35.2
 */
public enum StopReason {
    /**
     * Appropriately stopped by the sequence itself. This is the normal course of
     * action if the everything works as intended. All the other enumerated cases
     * are exceptional situations marking some kind of failure to complete the
     * sequence normally.
     */
    STOPPED,

    /**
     * Means simulation did not commence at all for some reason.
     * A few possible reasons for failure are:
     * <ul>
     * <li>Incompatible solver and model</li>
     * <li>Missing required files or other dependencies such as dynamic libraries</li>
     * <li>License issues</li>
     * </ul>
     */
    SIMULATION_DID_NOT_START,

    /**
     * Simulation diverged before reaching its specified end.
     */
    DIVERGED,

    /**
     * Client or some other party abruptly interrupted the sequence.
     */
    INTERRUPTED,
}