package org.simantics.scl.ui.console;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;

/**
 * @author Antti Villberg
 */
public final class Preferences {

    /**
     * Console buffer high and low water marks
     */
    public static final String CONSOLE_LIMIT_CONSOLE_OUTPUT = "SCLConsole.limitConsoleOutput";       //$NON-NLS-1$

    public static final String CONSOLE_LOW_WATER_MARK       = "SCLConsole.lowWaterMark";             //$NON-NLS-1$

    public static final String CONSOLE_HIGH_WATER_MARK      = "SCLConsole.highWaterMark";            //$NON-NLS-1$

    /**
     * By default console output buffer size is limited.
     */
    public static final boolean CONSOLE_LIMIT_CONSOLE_OUTPUT_DEFAULT = true;

    /**
     * The console low water mark default value {@value #CONSOLE_LOW_WATER_MARK_DEFAULT_VALUE}.
     */
    public static final int CONSOLE_LOW_WATER_MARK_DEFAULT_VALUE = 5000000;

    /**
     * The console low water mark default value {@value #CONSOLE_HIGH_WATER_MARK_DEFAULT_VALUE}.
     */
    public static final int CONSOLE_HIGH_WATER_MARK_DEFAULT_VALUE = highWatermarkForLow(CONSOLE_LOW_WATER_MARK_DEFAULT_VALUE);

    /**
     * The console low water mark maximum value {@value #CONSOLE_LOW_WATER_MARK_MAX_VALUE}.
     */
    public static final int CONSOLE_LOW_WATER_MARK_MAX_VALUE = 10000000;

    public static int highWatermarkForLow(int low) {
        return low + 80*100;
    }

    public static final String  COMMAND_HISTORY = "COMMAND_HISTORY"; //$NON-NLS-1$

    private static final String DELIMITER       = ""; //$NON-NLS-1$

    public static String join(Collection<String> s, String delimiter) {
        if (s == null || s.isEmpty()) return ""; //$NON-NLS-1$
        Iterator<String> iter = s.iterator();
        StringBuilder builder = new StringBuilder(iter.next());
        while( iter.hasNext() )
        {
            builder.append(delimiter).append(iter.next());
        }
        return builder.toString();
    }
    
    public static Deque<String> decodePaths(String recentPathsPref) {
        Deque<String> result = new LinkedList<String>();
        for(String s : recentPathsPref.split(DELIMITER)) result.add(s);
        return result;
    }

    public static String encodePaths(Collection<String> recentPaths) {
        return join(recentPaths, DELIMITER);
    }

    public static <T> void removeDuplicates(Iterable<String> iter) {
        // Remove duplicates
        Set<String> dups = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (Iterator<String> it = iter.iterator(); it.hasNext();) {
            String path = it.next();
            if (!dups.add(path)) {
                it.remove();
            }
        }
    }

}
