package org.simantics.scl.db;

import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.WriteEvents;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.utils.DataContainer;

class DelayedWriteRequestEvents<T> extends DelayedWriteRequest implements WriteEvents {

    private SCLContext context;
    private Function f;
    private Object oldGraph;
    DataContainer<T> dc = new DataContainer<>();
    
    DelayedWriteRequestEvents(Function f) {
        this.f = f;
        context = SCLContext.getCurrent();
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        SCLContext.push(context);
        oldGraph = context.put(SCLFunctions.GRAPH, graph);
        dc.set((T)f.apply(Tuple0.INSTANCE));
    }

    @Override
    public void afterListeners() {
        context.put(SCLFunctions.GRAPH, oldGraph);
        SCLContext.pop();
    }

}